/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.proto;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcResponse;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageWriter<T extends Message>
implements StreamObserver<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageWriter.class);
    private static final Gson GSON = new Gson();
    private final ShenyuGrpcResponse grpcResponse;

    private MessageWriter(ShenyuGrpcResponse grpcResponse) {
        this.grpcResponse = grpcResponse;
    }

    public static <T extends Message> MessageWriter<T> newInstance(ShenyuGrpcResponse results) {
        return new MessageWriter<T>(results);
    }

    public void onNext(T value) {
        String respData = JsonMessage.getDataFromDynamicMessage((DynamicMessage)((DynamicMessage)value));
        if (StringUtils.isNotBlank((CharSequence)respData)) {
            if (StringUtils.startsWith((CharSequence)(respData = respData.trim()), (CharSequence)"{") && StringUtils.endsWith((CharSequence)respData, (CharSequence)"}")) {
                this.grpcResponse.getResults().add(GSON.fromJson(respData, new TypeToken<HashMap<String, Object>>(){}.getType()));
            }
        } else {
            this.grpcResponse.getResults().add(respData);
        }
    }

    public void onError(Throwable t) {
        LOG.error("Messages write occur errors", t);
    }

    public void onCompleted() {
        LOG.info("Messages write complete");
    }
}

