/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.httpclient.AbstractHttpClientPlugin;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class NettyHttpClientPlugin
extends AbstractHttpClientPlugin<HttpClientResponse> {
    private final HttpClient httpClient;

    public NettyHttpClientPlugin(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    protected Mono<HttpClientResponse> doRequest(ServerWebExchange exchange, String httpMethod, URI uri, HttpHeaders httpHeaders, Flux<DataBuffer> body) {
        return Mono.from((Publisher)((HttpClient.RequestSender)this.httpClient.headers(headers -> httpHeaders.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)headers).add(arg_0, arg_1))).request(HttpMethod.valueOf((String)httpMethod)).uri(uri.toASCIIString())).send((req, nettyOutbound) -> nettyOutbound.send((Publisher)body.map(dataBuffer -> ((NettyDataBuffer)dataBuffer).getNativeBuffer()))).responseConnection((res, connection) -> {
            HttpStatus status;
            exchange.getAttributes().put("webHandlerClientResponse", res);
            exchange.getAttributes().put("nettyClientResponseConnection", connection);
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            String contentTypeValue = headers.getFirst("Content-Type");
            if (StringUtils.isNotBlank((CharSequence)contentTypeValue)) {
                exchange.getAttributes().put("original_response_content_type", contentTypeValue);
            }
            if ((status = HttpStatus.resolve((int)res.status().code())) != null) {
                response.setStatusCode(status);
            } else if (response instanceof AbstractServerHttpResponse) {
                response.setRawStatusCode(Integer.valueOf(res.status().code()));
            } else {
                throw new IllegalStateException("Unable to set status code on response: " + res.status().code() + ", " + response.getClass());
            }
            response.getHeaders().putAll((Map)headers);
            return Mono.just((Object)res);
        }));
    }

    public int getOrder() {
        return PluginEnum.NETTY_HTTP_CLIENT.getCode();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }

    public String named() {
        return PluginEnum.NETTY_HTTP_CLIENT.getName();
    }
}

