/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.plugin.base.utils.MediaTypeUtils;
import org.apache.shenyu.plugin.httpclient.AbstractHttpClientPlugin;
import org.apache.shenyu.plugin.httpclient.config.DuplicateResponseHeaderProperties;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebClientPlugin
extends AbstractHttpClientPlugin<ResponseEntity<Flux<DataBuffer>>> {
    private final WebClient webClient;
    private final DuplicateResponseHeaderProperties properties;

    public WebClientPlugin(WebClient webClient, DuplicateResponseHeaderProperties properties) {
        this.webClient = webClient;
        this.properties = properties;
    }

    @Override
    protected Mono<ResponseEntity<Flux<DataBuffer>>> doRequest(ServerWebExchange exchange, String httpMethod, URI uri, Flux<DataBuffer> body) {
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)httpMethod)).uri(uri)).headers(headers -> {
            headers.addAll((MultiValueMap)exchange.getRequest().getHeaders());
            headers.remove((Object)"Host");
        })).body((outputMessage, context) -> {
            MediaType mediaType = exchange.getRequest().getHeaders().getContentType();
            if (MediaTypeUtils.isByteType((MediaType)mediaType)) {
                return outputMessage.writeWith((Publisher)body);
            }
            return outputMessage.writeWith((Publisher)DataBufferUtils.join((Publisher)body));
        }).retrieve().onRawStatus(httpStatus -> httpStatus >= 400, clientResponse -> Mono.empty());
        return responseSpec.toEntityFlux(DataBuffer.class).flatMap(fluxResponseEntity -> {
            if (fluxResponseEntity.getStatusCode().is2xxSuccessful()) {
                exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            } else {
                exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            }
            HttpHeaders headers = new HttpHeaders();
            headers.addAll((MultiValueMap)fluxResponseEntity.getHeaders());
            this.duplicate(headers);
            exchange.getResponse().getHeaders().putAll((Map)headers);
            exchange.getResponse().setStatusCode(fluxResponseEntity.getStatusCode());
            exchange.getAttributes().put("webHandlerClientResponse", fluxResponseEntity);
            return Mono.just((Object)fluxResponseEntity);
        });
    }

    private void duplicate(HttpHeaders headers) {
        List<String> duplicateHeaders = this.properties.getHeaders();
        if (CollectionUtils.isEmpty(duplicateHeaders)) {
            return;
        }
        DuplicateResponseHeaderProperties.DuplicateResponseHeaderStrategy strategy = this.properties.getStrategy();
        for (String headerKey : duplicateHeaders) {
            this.duplicateHeaders(headers, headerKey, strategy);
        }
    }

    public int getOrder() {
        return PluginEnum.WEB_CLIENT.getCode();
    }

    public String named() {
        return PluginEnum.WEB_CLIENT.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }
}

