/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.command;

import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.exception.HystrixTimeoutException;
import java.net.URI;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.fallback.FallbackHandler;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;

public interface Command
extends FallbackHandler {
    public Observable<Void> fetchObservable();

    public boolean isCircuitBreakerOpen();

    default public Mono<Void> withoutFallback(ServerWebExchange exchange, Throwable throwable) {
        Object error;
        if (throwable instanceof HystrixRuntimeException) {
            HystrixRuntimeException e = (HystrixRuntimeException)throwable;
            if (e.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
                error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_TIMEOUT);
            } else {
                exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
            }
        } else if (throwable instanceof HystrixTimeoutException) {
            exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
            error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_TIMEOUT);
        } else {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public URI getCallBackUri();

    public void removeCommandKey(String var1);

    public void cleanCommand();
}

