/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.handler;

import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.HystrixHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.hystrix.builder.HystrixBuilder;
import org.apache.shenyu.plugin.hystrix.command.HystrixCommand;
import org.springframework.util.StringUtils;

public class HystrixPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, HystrixHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerSelector(SelectorData selectorData) {
        if (!selectorData.getContinued().booleanValue()) {
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)HystrixHandle.newDefaultInstance());
        }
    }

    public void removeSelector(SelectorData selectorData) {
        CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public void handlerRule(RuleData ruleData) {
        HystrixPropertiesFactory.reset();
        Optional.ofNullable(ruleData.getHandle()).ifPresent(rule -> {
            HystrixHandle hystrixHandle = (HystrixHandle)GsonUtils.getInstance().fromJson(rule, HystrixHandle.class);
            String key = CacheKeyUtils.INST.getKey(ruleData);
            Optional.ofNullable(CACHED_HANDLE.get().obtainHandle((Object)key)).ifPresent(hystrixHandleCache -> {
                if (hystrixHandleCache.getMaxConcurrentRequests() != hystrixHandle.getMaxConcurrentRequests()) {
                    String commandKey = hystrixHandle.getCommandKey();
                    HystrixCommand command = new HystrixCommand(HystrixBuilder.build(hystrixHandle), null, null, null);
                    command.removeCommandKey(commandKey);
                }
                if (hystrixHandleCache.getExecutionIsolationStrategy() != hystrixHandle.getExecutionIsolationStrategy()) {
                    HystrixCommand command = new HystrixCommand(HystrixBuilder.build(hystrixHandleCache), null, null, null);
                    if (StringUtils.hasText((String)hystrixHandle.getCommandKey())) {
                        command.removeCommandKey(hystrixHandle.getCommandKey());
                    } else {
                        command.cleanCommand();
                    }
                }
            });
            CACHED_HANDLE.get().cachedHandle((Object)key, (Object)hystrixHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(rule -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.HYSTRIX.getName();
    }
}

