/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt;

import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.JwtRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtPlugin
extends AbstractShenyuPlugin {
    private static final String TOKEN = "token";
    private static final String AUTH2_TOKEN = "Bearer";

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        JwtConfig jwtConfig = (JwtConfig)Singleton.INST.get(JwtConfig.class);
        String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
        String token = exchange.getRequest().getHeaders().getFirst(TOKEN);
        if (StringUtils.isEmpty((CharSequence)jwtConfig.getSecretKey())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SECRET_KEY_MUST_BE_CONFIGURED);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String finalAuthorization = this.compatible(token, authorization);
        Map<String, Object> jwtBody = this.checkAuthorization(finalAuthorization, jwtConfig.getSecretKey());
        if (jwtBody != null) {
            JwtRuleHandle ruleHandle = (JwtRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), JwtRuleHandle.class);
            if (ruleHandle == null) {
                return chain.execute(exchange);
            }
            return chain.execute(this.converter(exchange, jwtBody, ruleHandle.getConverter()));
        }
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ERROR_TOKEN);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public String named() {
        return PluginEnum.JWT.getName();
    }

    public int getOrder() {
        return PluginEnum.JWT.getCode();
    }

    private String compatible(String token, String authorization) {
        String finalAuthorization;
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            finalAuthorization = token;
        } else if (StringUtils.isNotEmpty((CharSequence)authorization)) {
            finalAuthorization = authorization;
        } else {
            return null;
        }
        return this.isAuth2(finalAuthorization) ? finalAuthorization.split(" ")[1] : finalAuthorization;
    }

    private boolean isAuth2(String authorization) {
        return authorization.contains(AUTH2_TOKEN);
    }

    private Map<String, Object> checkAuthorization(String authorization, String secretKey) {
        if (StringUtils.isEmpty((CharSequence)authorization)) {
            return null;
        }
        JwtParserBuilder jwtParserBuilder = Jwts.parserBuilder();
        JwtParser jwtParser = jwtParserBuilder.build();
        if (jwtParser.isSigned(authorization)) {
            jwtParserBuilder.setSigningKey(secretKey.getBytes(StandardCharsets.UTF_8));
            JwtParser jwtParserExec = jwtParserBuilder.build();
            Jwt jwt = ThrowingFunction.wrap(() -> jwtParserExec.parse(authorization));
            if (jwt == null) {
                return null;
            }
            return (Map)jwt.getBody();
        }
        return null;
    }

    private ServerWebExchange converter(ServerWebExchange exchange, Map<String, Object> jwtBody, List<JwtRuleHandle.Convert> converters) {
        ServerHttpRequest modifiedRequest = exchange.getRequest().mutate().headers(httpHeaders -> this.addHeader((HttpHeaders)httpHeaders, jwtBody, converters)).build();
        return exchange.mutate().request(modifiedRequest).build();
    }

    private void addHeader(HttpHeaders headers, Map<String, Object> body, List<JwtRuleHandle.Convert> converters) {
        for (JwtRuleHandle.Convert converter : converters) {
            if (converter.getJwtVal().contains(".")) {
                headers.add(converter.getHeaderVal(), this.parse(body, converter.getJwtVal().split("\\."), new AtomicInteger(0)));
                continue;
            }
            headers.add(converter.getHeaderVal(), String.valueOf(body.get(converter.getJwtVal())));
        }
    }

    private String parse(Map<String, Object> body, String[] split, AtomicInteger deep) {
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            if (deep.get() == split.length - 1) {
                return String.valueOf(body.get(split[deep.get()]));
            }
            if (!entry.getKey().equals(split[deep.get()]) || !(entry.getValue() instanceof Map)) continue;
            deep.incrementAndGet();
            return this.parse((Map)entry.getValue(), split, deep);
        }
        return String.valueOf(body.get(split[deep.get()]));
    }
}

