/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt;

import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.apache.shenyu.plugin.jwt.handle.JwtPluginDataHandler;
import org.apache.shenyu.plugin.jwt.rule.JwtRuleHandle;
import org.apache.shenyu.plugin.jwt.strategy.JwtConvertStrategy;
import org.apache.shenyu.plugin.jwt.strategy.JwtConvertStrategyFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtPlugin
extends AbstractShenyuPlugin {
    private static final String TOKEN = "token";
    private static final String AUTH2_TOKEN = "Bearer";

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        JwtConfig jwtConfig = (JwtConfig)Singleton.INST.get(JwtConfig.class);
        String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
        String token = exchange.getRequest().getHeaders().getFirst(TOKEN);
        if (StringUtils.isEmpty((CharSequence)jwtConfig.getSecretKey())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SECRET_KEY_MUST_BE_CONFIGURED);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String finalAuthorization = this.compatible(token, authorization);
        Map<String, Object> jwtBody = this.checkAuthorization(finalAuthorization, jwtConfig.getSecretKey());
        if (Objects.isNull(jwtBody)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ERROR_TOKEN);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.execute(this.executeRuleHandle(rule, exchange, jwtBody));
    }

    public String named() {
        return PluginEnum.JWT.getName();
    }

    public int getOrder() {
        return PluginEnum.JWT.getCode();
    }

    private ServerWebExchange executeRuleHandle(RuleData ruleData, ServerWebExchange exchange, Map<String, Object> jwtBody) {
        JwtRuleHandle jwtRuleHandle = (JwtRuleHandle)JwtPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(ruleData));
        if (Objects.isNull(jwtRuleHandle)) {
            return exchange;
        }
        JwtConvertStrategy convertStrategy = JwtConvertStrategyFactory.newInstance(jwtRuleHandle.getHandleType());
        return convertStrategy.convert(jwtRuleHandle, exchange, jwtBody);
    }

    private String compatible(String token, String authorization) {
        String finalAuthorization;
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            finalAuthorization = token;
        } else if (StringUtils.isNotEmpty((CharSequence)authorization)) {
            finalAuthorization = authorization;
        } else {
            return null;
        }
        return this.isAuth2(finalAuthorization) ? finalAuthorization.split(" ")[1] : finalAuthorization;
    }

    private boolean isAuth2(String authorization) {
        return authorization.contains(AUTH2_TOKEN);
    }

    private Map<String, Object> checkAuthorization(String authorization, String secretKey) {
        if (StringUtils.isEmpty((CharSequence)authorization)) {
            return null;
        }
        JwtParserBuilder jwtParserBuilder = Jwts.parserBuilder();
        JwtParser jwtParser = jwtParserBuilder.build();
        if (jwtParser.isSigned(authorization)) {
            jwtParserBuilder.setSigningKey(secretKey.getBytes(StandardCharsets.UTF_8));
            JwtParser jwtParserExec = jwtParserBuilder.build();
            Jwt jwt = ThrowingFunction.wrap(() -> jwtParserExec.parse(authorization));
            if (jwt == null) {
                return null;
            }
            return (Map)jwt.getBody();
        }
        return null;
    }
}

