/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt.rule;

import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.dto.convert.rule.RuleHandle;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.jwt.strategy.JwtConvertStrategy;
import org.apache.shenyu.plugin.jwt.strategy.JwtConvertStrategyFactory;

public class JwtRuleHandle
implements RuleHandle {
    private String handleType;

    public String getHandleType() {
        return this.handleType;
    }

    public void setHandleType(String handleType) {
        this.handleType = handleType;
    }

    public static JwtRuleHandle newInstance(String handleJson) {
        if (Objects.isNull(handleJson)) {
            return null;
        }
        Map handleMap = GsonUtils.getInstance().convertToMap(handleJson);
        String handleType = null;
        if (Objects.nonNull(handleMap)) {
            handleType = handleMap.getOrDefault("handleType", "default").toString();
        }
        JwtConvertStrategy convertStrategy = JwtConvertStrategyFactory.newInstance(handleType);
        return convertStrategy.parseHandleJson(handleJson);
    }
}

