/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.HostAddressUtils;
import org.apache.shenyu.plugin.logging.common.body.LoggingServerHttpRequest;
import org.apache.shenyu.plugin.logging.common.body.LoggingServerHttpResponse;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.entity.CommonLoggingRuleHandle;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.common.handler.AbstractLogPluginDataHandler;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectUtils;
import org.apache.shenyu.plugin.logging.desensitize.api.enums.DataDesensitizeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractLoggingPlugin<L extends ShenyuRequestLog>
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLoggingPlugin.class);

    protected abstract LogCollector<L> logCollector();

    protected abstract PluginEnum pluginEnum();

    protected abstract L doLogExecute(ServerWebExchange var1, SelectorData var2, RuleData var3);

    public Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CommonLoggingRuleHandle commonLoggingRuleHandle = (CommonLoggingRuleHandle)AbstractLogPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        boolean desensitized = Boolean.FALSE;
        HashSet keywordSets = Sets.newHashSet();
        String dataDesensitizeAlg = DataDesensitizeEnum.MD5_ENCRYPT.getDataDesensitizeAlg();
        if (Objects.nonNull(commonLoggingRuleHandle)) {
            String keywords = commonLoggingRuleHandle.getKeyword();
            boolean bl = desensitized = StringUtils.isNotBlank((CharSequence)keywords) && commonLoggingRuleHandle.getMaskStatus() != false;
            if (desensitized) {
                Collections.addAll(keywordSets, keywords.split(";"));
                dataDesensitizeAlg = Optional.ofNullable(commonLoggingRuleHandle.getMaskType()).orElse(DataDesensitizeEnum.MD5_ENCRYPT.getDataDesensitizeAlg());
                LOG.info("current plugin:{}, keyword:{}, dataDesensitizeAlg:{}", new Object[]{this.pluginEnum().getName(), keywords, dataDesensitizeAlg});
            }
        }
        ServerHttpRequest request = exchange.getRequest();
        if (!LogCollectConfigUtils.isSampled(exchange, selector)) {
            return chain.execute(exchange);
        }
        L requestInfo = this.doLogExecute(exchange, selector, rule);
        ((ShenyuRequestLog)requestInfo).setRequestUri(request.getURI().toString());
        ((ShenyuRequestLog)requestInfo).setMethod(request.getMethodValue());
        ((ShenyuRequestLog)requestInfo).setRequestHeader(LogCollectUtils.getHeaders(request.getHeaders()));
        ((ShenyuRequestLog)requestInfo).setQueryParams(request.getURI().getQuery());
        ((ShenyuRequestLog)requestInfo).setClientIp(HostAddressUtils.acquireIp((ServerWebExchange)exchange));
        ((ShenyuRequestLog)requestInfo).setUserAgent(request.getHeaders().getFirst("User-Agent"));
        ((ShenyuRequestLog)requestInfo).setHost(request.getHeaders().getFirst("Host"));
        ((ShenyuRequestLog)requestInfo).setPath(request.getURI().getRawPath());
        ((ShenyuRequestLog)requestInfo).setSelectorId(selector.getId());
        ((ShenyuRequestLog)requestInfo).setRuleId(rule.getId());
        LoggingServerHttpRequest<L> loggingServerHttpRequest = new LoggingServerHttpRequest<L>(request, requestInfo);
        LoggingServerHttpResponse<L> loggingServerHttpResponse = new LoggingServerHttpResponse<L>(exchange.getResponse(), requestInfo, this.logCollector(), desensitized, keywordSets, dataDesensitizeAlg);
        ServerWebExchange webExchange = exchange.mutate().request(loggingServerHttpRequest).response(loggingServerHttpResponse).build();
        loggingServerHttpResponse.setExchange(webExchange);
        return chain.execute(webExchange).doOnError(loggingServerHttpResponse::logError);
    }

    public int getOrder() {
        return this.pluginEnum().getCode();
    }

    public String named() {
        return this.pluginEnum().getName();
    }
}

