/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.body;

import org.apache.shenyu.plugin.logging.common.body.BodyWriter;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import reactor.core.publisher.Flux;
import reactor.util.annotation.NonNull;

public class LoggingServerHttpRequest<L extends ShenyuRequestLog>
extends ServerHttpRequestDecorator {
    private final L logInfo;

    public LoggingServerHttpRequest(ServerHttpRequest delegate, L logInfo) {
        super(delegate);
        this.logInfo = logInfo;
    }

    @NonNull
    public Flux<DataBuffer> getBody() {
        BodyWriter writer = new BodyWriter();
        return super.getBody().doOnNext(dataBuffer -> {
            if (LogCollectUtils.isNotBinaryType(this.getHeaders())) {
                writer.write(dataBuffer.asByteBuffer().asReadOnlyBuffer());
            }
        }).doFinally(signal -> {
            int size = writer.size();
            String body = writer.output();
            boolean requestBodyTooLarge = LogCollectConfigUtils.isRequestBodyTooLarge(size);
            if (size == 0 || requestBodyTooLarge) {
                return;
            }
            ((ShenyuRequestLog)this.logInfo).setRequestBody(body);
        });
    }
}

