/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.collector;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shenyu.common.concurrent.MemorySafeTaskQueue;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;
import org.apache.shenyu.common.concurrent.TaskQueue;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.common.utils.ThreadUtils;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.config.GenericGlobalConfig;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.desensitize.api.matcher.KeyWordMatch;
import org.apache.shenyu.plugin.logging.desensitize.api.utils.DataDesensitizeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogCollector<T extends AbstractLogConsumeClient<?, L>, L extends ShenyuRequestLog, C extends GenericGlobalConfig>
implements LogCollector<L> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLogCollector.class);
    private int bufferSize;
    private BlockingQueue<L> bufferQueue;
    private long lastPushTime;
    private final AtomicBoolean started = new AtomicBoolean(true);

    @Override
    public void start() {
        this.bufferSize = ((GenericGlobalConfig)this.getLogCollectConfig()).getBufferQueueSize();
        this.bufferQueue = new LinkedBlockingDeque<L>(this.bufferSize);
        ShenyuConfig config = (ShenyuConfig)Optional.ofNullable(Singleton.INST.get(ShenyuConfig.class)).orElse(new ShenyuConfig());
        ShenyuConfig.SharedPool sharedPool = config.getSharedPool();
        ShenyuThreadPoolExecutor threadExecutor = new ShenyuThreadPoolExecutor(sharedPool.getCorePoolSize().intValue(), sharedPool.getMaximumPoolSize().intValue(), sharedPool.getKeepAliveTime().longValue(), TimeUnit.MILLISECONDS, (TaskQueue)new MemorySafeTaskQueue(0x10000000), ShenyuThreadFactory.create((String)config.getSharedPool().getPrefix(), (boolean)true), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        this.started.set(true);
        threadExecutor.execute(this::consume);
    }

    @Override
    public void collect(L log) {
        if (Objects.isNull(log) || Objects.isNull(this.getLogConsumeClient())) {
            return;
        }
        if (this.bufferQueue.size() < this.bufferSize) {
            this.bufferQueue.add(log);
        }
    }

    @Override
    public void desensitize(L logInfo, KeyWordMatch keyWordMatch, String desensitizeAlg) {
        this.desensitizeShenyuRequestLog(logInfo, keyWordMatch, desensitizeAlg);
        this.desensitizeLog(logInfo, keyWordMatch, desensitizeAlg);
    }

    private void consume() {
        while (this.started.get()) {
            int diffTimeMSForPush = 100;
            try {
                ArrayList logs = new ArrayList();
                int size = this.bufferQueue.size();
                long time = System.currentTimeMillis();
                long timeDiffMs = time - this.lastPushTime;
                int batchSize = 100;
                if (size >= batchSize || timeDiffMs > (long)diffTimeMSForPush) {
                    this.bufferQueue.drainTo(logs, batchSize);
                    T logCollectClient = this.getLogConsumeClient();
                    if (Objects.nonNull(logCollectClient)) {
                        ((AbstractLogConsumeClient)logCollectClient).consume(logs);
                    }
                    this.lastPushTime = time;
                    continue;
                }
                ThreadUtils.sleep((TimeUnit)TimeUnit.MILLISECONDS, (int)diffTimeMSForPush);
            }
            catch (Exception e) {
                LOG.error("DefaultLogCollector collect log error", (Throwable)e);
                ThreadUtils.sleep((TimeUnit)TimeUnit.MILLISECONDS, (int)diffTimeMSForPush);
            }
        }
    }

    private void desensitizeShenyuRequestLog(L logInfo, KeyWordMatch keyWordMatch, String desensitizedAlg) {
        ((ShenyuRequestLog)logInfo).setClientIp(DataDesensitizeUtils.desensitizeForSingleWord((String)"clientIp", (String)((ShenyuRequestLog)logInfo).getClientIp(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setTimeLocal(DataDesensitizeUtils.desensitizeForSingleWord((String)"timeLocal", (String)((ShenyuRequestLog)logInfo).getTimeLocal(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setMethod(DataDesensitizeUtils.desensitizeForSingleWord((String)"method", (String)((ShenyuRequestLog)logInfo).getMethod(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setRequestUri(DataDesensitizeUtils.desensitizeForSingleWord((String)"requestUri", (String)((ShenyuRequestLog)logInfo).getRequestUri(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setResponseContentLength(Integer.valueOf(DataDesensitizeUtils.desensitizeForSingleWord((String)"responseContentLength", (String)((ShenyuRequestLog)logInfo).getResponseContentLength().toString(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg)));
        ((ShenyuRequestLog)logInfo).setRpcType(DataDesensitizeUtils.desensitizeForSingleWord((String)"rpcType", (String)((ShenyuRequestLog)logInfo).getRpcType(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setStatus(Integer.valueOf(DataDesensitizeUtils.desensitizeForSingleWord((String)"status", (String)((ShenyuRequestLog)logInfo).getStatus().toString(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg)));
        ((ShenyuRequestLog)logInfo).setUpstreamIp(DataDesensitizeUtils.desensitizeForSingleWord((String)"upstreamIp", (String)((ShenyuRequestLog)logInfo).getUpstreamIp(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setUpstreamResponseTime(Long.valueOf(DataDesensitizeUtils.desensitizeForSingleWord((String)"upstreamResponseTime", (String)((ShenyuRequestLog)logInfo).getUpstreamResponseTime().toString(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg)));
        ((ShenyuRequestLog)logInfo).setUserAgent(DataDesensitizeUtils.desensitizeForSingleWord((String)"userAgent", (String)((ShenyuRequestLog)logInfo).getUserAgent(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setHost(DataDesensitizeUtils.desensitizeForSingleWord((String)"Host", (String)((ShenyuRequestLog)logInfo).getHost(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setModule(DataDesensitizeUtils.desensitizeForSingleWord((String)"module", (String)((ShenyuRequestLog)logInfo).getModule(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setTraceId(DataDesensitizeUtils.desensitizeForSingleWord((String)"traceId", (String)((ShenyuRequestLog)logInfo).getTraceId(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setPath(DataDesensitizeUtils.desensitizeForSingleWord((String)"path", (String)((ShenyuRequestLog)logInfo).getPath(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setRequestHeader(DataDesensitizeUtils.desensitizeForSingleWord((String)"requestHeader", (String)((ShenyuRequestLog)logInfo).getRequestHeader(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setResponseHeader(DataDesensitizeUtils.desensitizeForSingleWord((String)"responseHeader", (String)((ShenyuRequestLog)logInfo).getResponseHeader(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setQueryParams(DataDesensitizeUtils.desensitizeForSingleWord((String)"queryParams", (String)((ShenyuRequestLog)logInfo).getQueryParams(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setRequestBody(DataDesensitizeUtils.desensitizeForSingleWord((String)"requestBody", (String)((ShenyuRequestLog)logInfo).getRequestBody(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setResponseBody(DataDesensitizeUtils.desensitizeForSingleWord((String)"responseBody", (String)((ShenyuRequestLog)logInfo).getResponseBody(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setRequestHeader(DataDesensitizeUtils.desensitizeForBody((String)((ShenyuRequestLog)logInfo).getRequestHeader(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setResponseHeader(DataDesensitizeUtils.desensitizeForBody((String)((ShenyuRequestLog)logInfo).getResponseHeader(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setQueryParams(DataDesensitizeUtils.desensitizeForBody((String)((ShenyuRequestLog)logInfo).getQueryParams(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setRequestBody(DataDesensitizeUtils.desensitizeForBody((String)((ShenyuRequestLog)logInfo).getRequestBody(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
        ((ShenyuRequestLog)logInfo).setResponseBody(DataDesensitizeUtils.desensitizeForBody((String)((ShenyuRequestLog)logInfo).getResponseBody(), (KeyWordMatch)keyWordMatch, (String)desensitizedAlg));
    }

    protected abstract T getLogConsumeClient();

    protected abstract C getLogCollectConfig();

    protected abstract void desensitizeLog(L var1, KeyWordMatch var2, String var3);

    @Override
    public void close() throws Exception {
        this.started.set(false);
        T logCollectClient = this.getLogConsumeClient();
        if (logCollectClient != null) {
            ((AbstractLogConsumeClient)logCollectClient).close();
        }
    }
}

