/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.utils;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.logging.common.config.GenericGlobalConfig;
import org.apache.shenyu.plugin.logging.common.handler.AbstractLogPluginDataHandler;
import org.apache.shenyu.plugin.logging.common.sampler.CountSampler;
import org.apache.shenyu.plugin.logging.common.sampler.Sampler;
import org.springframework.web.server.ServerWebExchange;

public final class LogCollectConfigUtils {
    private static GenericGlobalConfig genericGlobalConfig = new GenericGlobalConfig();
    private static Sampler globalSampler = Sampler.ALWAYS_SAMPLE;

    private LogCollectConfigUtils() {
    }

    public static Sampler setSampler(String sampler) {
        if (StringUtils.isBlank((CharSequence)sampler)) {
            return globalSampler;
        }
        return CountSampler.create(sampler);
    }

    public static void setGlobalSampler(String sampler) {
        if (StringUtils.isNotBlank((CharSequence)sampler)) {
            try {
                globalSampler = CountSampler.create(sampler);
            }
            catch (Exception e) {
                globalSampler = Sampler.ALWAYS_SAMPLE;
            }
        }
    }

    public static boolean isRequestBodyTooLarge(int bodySize) {
        if (Objects.isNull(genericGlobalConfig)) {
            return false;
        }
        return bodySize > genericGlobalConfig.getMaxRequestBody();
    }

    public static boolean isResponseBodyTooLarge(int bodySize) {
        if (Objects.isNull(genericGlobalConfig)) {
            return false;
        }
        return bodySize > genericGlobalConfig.getMaxResponseBody();
    }

    public static boolean isSampled(ServerWebExchange exchange, SelectorData selectorData) {
        return Optional.ofNullable(AbstractLogPluginDataHandler.getSelectApiConfigMap().get(selectorData.getId())).map(config -> config.getSampler().isSampled(exchange, selectorData)).orElseGet(() -> Optional.ofNullable(AbstractLogPluginDataHandler.getPluginGlobalConfigMap().get(selectorData.getPluginId())).map(config -> config.getSampler().isSampled(exchange, selectorData)).orElse(true));
    }
}

