/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rocketmq.client;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.LZ4CompressData;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.rocketmq.config.RocketMQLogCollectConfig;
import org.apache.shenyu.plugin.logging.rocketmq.handler.LoggingRocketMQPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class RocketMQLogCollectClient
extends AbstractLogConsumeClient<RocketMQLogCollectConfig.RocketMQLogConfig, ShenyuRequestLog> {
    private static final Logger LOG = LoggerFactory.getLogger(RocketMQLogCollectClient.class);
    private static Map<String, String> apiTopicMap = new HashMap<String, String>();
    private static final String DEFAULT_PRODUCER_GROUP = "shenyu-plugin-logging-rocketmq";
    private DefaultMQProducer producer;
    private String topic;

    public void initClient0(@NonNull RocketMQLogCollectConfig.RocketMQLogConfig config) {
        String topic = config.getTopic();
        String nameserverAddress = config.getNamesrvAddr();
        String producerGroup = config.getProducerGroup();
        producerGroup = Optional.ofNullable(producerGroup).orElse(DEFAULT_PRODUCER_GROUP);
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)nameserverAddress)) {
            LOG.error("init RocketMQLogCollectClient error, please check topic or nameserverAddress");
            return;
        }
        this.topic = topic;
        this.producer = new DefaultMQProducer(producerGroup, this.getAclRPCHook(config));
        this.producer.setNamesrvAddr(nameserverAddress);
        this.producer.setRetryTimesWhenSendAsyncFailed(0);
        this.producer.setInstanceName(DEFAULT_PRODUCER_GROUP);
        try {
            this.producer.start();
            LOG.info("init RocketMQLogCollectClient success");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((RocketMQLogCollectClient)this).close()));
        }
        catch (Exception e) {
            LOG.error("init RocketMQLogCollectClient error", (Throwable)e);
        }
    }

    private RPCHook getAclRPCHook(RocketMQLogCollectConfig.RocketMQLogConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getAccessKey()) || StringUtils.isBlank((CharSequence)config.getSecretKey())) {
            return null;
        }
        return new AclClientRPCHook(new SessionCredentials(config.getAccessKey(), config.getSecretKey()));
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) {
        logs.forEach(log -> {
            String logTopic = Optional.ofNullable(LoggingRocketMQPluginDataHandler.getSelectApiConfigMap().get(log.getSelectorId())).map(apiConfig -> (String)StringUtils.defaultIfBlank((CharSequence)apiConfig.getTopic(), (CharSequence)this.topic)).orElse(this.topic);
            try {
                this.producer.sendOneway(this.toMessage(logTopic, (ShenyuRequestLog)log));
            }
            catch (Exception e) {
                LOG.error("rocketmq push logs error", (Throwable)e);
            }
        });
    }

    private Message toMessage(String logTopic, ShenyuRequestLog log) {
        byte[] bytes = JsonUtils.toJson((Object)log).getBytes(StandardCharsets.UTF_8);
        String compressAlg = (String)StringUtils.defaultIfBlank((CharSequence)RocketMQLogCollectConfig.INSTANCE.getRocketMQLogConfig().getCompressAlg(), (CharSequence)"");
        if ("LZ4".equalsIgnoreCase(compressAlg.trim())) {
            LZ4CompressData lz4CompressData = new LZ4CompressData(bytes.length, this.compressedByte(bytes));
            return new Message(logTopic, JsonUtils.toJson((Object)lz4CompressData).getBytes(StandardCharsets.UTF_8));
        }
        return new Message(logTopic, bytes);
    }

    private byte[] compressedByte(byte[] srcByte) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        return compressor.compress(srcByte);
    }

    public static void setTopic(Map<String, String> uriTopicMap) {
        apiTopicMap = uriTopicMap;
    }

    public void close0() {
        if (Objects.nonNull(this.producer)) {
            this.producer.shutdown();
        }
    }
}

