/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.metrics;

import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.metrics.reporter.MetricsReporter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MetricsPlugin
implements ShenyuPlugin {
    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        MetricsReporter.counterIncrement("shenyu_request_total");
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        MetricsReporter.counterIncrement("shenyu_request_type_total", new String[]{exchange.getRequest().getURI().getRawPath(), shenyuContext.getRpcType()});
        LocalDateTime startDateTime = Optional.of(shenyuContext).map(ShenyuContext::getStartDateTime).orElseGet(LocalDateTime::now);
        return chain.execute(exchange).doOnSuccess(e -> this.responseCommitted(exchange, startDateTime)).doOnError(throwable -> {
            MetricsReporter.counterIncrement("shenyu_request_throw_total");
            this.responseCommitted(exchange, startDateTime);
        });
    }

    public int getOrder() {
        return PluginEnum.METRICS.getCode();
    }

    public String named() {
        return PluginEnum.METRICS.getName();
    }

    private void responseCommitted(ServerWebExchange exchange, LocalDateTime startDateTime) {
        ServerHttpResponse response = exchange.getResponse();
        if (response.isCommitted()) {
            this.recordTime(startDateTime);
        } else {
            response.beforeCommit(() -> {
                this.recordTime(startDateTime);
                return Mono.empty();
            });
        }
    }

    private void recordTime(LocalDateTime startDateTime) {
        long millisBetween = DateUtils.acquireMillisBetween((LocalDateTime)startDateTime, (LocalDateTime)LocalDateTime.now());
        MetricsReporter.recordTime("shenyu_execute_latency_millis", millisBetween);
    }
}

