/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.MockHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.mock.api.MockRequest;
import org.apache.shenyu.plugin.mock.generator.GeneratorFactory;
import org.apache.shenyu.plugin.mock.handler.MockPluginHandler;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MockPlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        MockHandle mockHandle = (MockHandle)MockPluginHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(mockHandle)) {
            return chain.execute(exchange);
        }
        exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        exchange.getResponse().setStatusCode(HttpStatus.valueOf((int)mockHandle.getHttpStatusCode()));
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).switchIfEmpty(Mono.just((Object)DefaultDataBufferFactory.sharedInstance.allocateBuffer(0))).map(dataBuffer -> this.dealRule((DataBuffer)dataBuffer, mockHandle.getResponseContent(), exchange.getRequest())).flatMap(bytes -> exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(bytes)).doOnNext(data -> exchange.getResponse().getHeaders().setContentLength((long)data.readableByteCount()))));
    }

    public int getOrder() {
        return PluginEnum.MOCK.getCode();
    }

    public String named() {
        return PluginEnum.MOCK.getName();
    }

    private byte[] dealRule(DataBuffer requestBodyBuffer, String response, ServerHttpRequest serverHttpRequest) {
        byte[] originalBody = new byte[requestBodyBuffer.readableByteCount()];
        requestBodyBuffer.read(originalBody);
        DataBufferUtils.release((DataBuffer)requestBodyBuffer);
        MockRequest mockRequest = this.buildMockRequest(originalBody, serverHttpRequest);
        return GeneratorFactory.dealRule(response, mockRequest).getBytes(StandardCharsets.UTF_8);
    }

    private MockRequest buildMockRequest(byte[] originalBody, ServerHttpRequest serverHttpRequest) {
        return MockRequest.Builder.builder().headers(serverHttpRequest.getHeaders().toSingleValueMap()).method(serverHttpRequest.getMethodValue()).queries(serverHttpRequest.getQueryParams().toSingleValueMap()).uri(serverHttpRequest.getURI().toString()).body(originalBody).build();
    }
}

