/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.modify.response;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ModifyResponseRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.modify.response.handler.ModifyResponsePluginDataHandler;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ModifyResponsePlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyResponsePlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        ModifyResponseRuleHandle ruleHandle = (ModifyResponseRuleHandle)ModifyResponsePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(ruleHandle)) {
            return chain.execute(exchange);
        }
        return chain.execute(exchange.mutate().response((ServerHttpResponse)new ModifyResponseDecorator(exchange, ruleHandle)).build());
    }

    public int getOrder() {
        return PluginEnum.MODIFY_RESPONSE.getCode();
    }

    public String named() {
        return PluginEnum.MODIFY_RESPONSE.getName();
    }

    static class ModifyResponseDecorator
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final ModifyResponseRuleHandle ruleHandle;

        ModifyResponseDecorator(ServerWebExchange exchange, ModifyResponseRuleHandle ruleHandle) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.ruleHandle = ruleHandle;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            Mono dataBufferMono = DataBufferUtils.join(body);
            this.buildModifiedResponse(body);
            return dataBufferMono.flatMap(dataBuffer -> {
                byte[] bytes = new byte[dataBuffer.readableByteCount()];
                dataBuffer.read(bytes);
                return WebFluxResultUtils.result((ServerWebExchange)this.exchange, (Object)this.modifyBody(bytes));
            });
        }

        private void buildModifiedResponse(Publisher<? extends DataBuffer> body) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.addAll((MultiValueMap)this.getHeaders());
            if (MapUtils.isNotEmpty((Map)this.ruleHandle.getAddHeaders())) {
                Map addHeaderMap = this.ruleHandle.getAddHeaders();
                addHeaderMap.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
            if (MapUtils.isNotEmpty((Map)this.ruleHandle.getSetHeaders())) {
                Map setHeaderMap = this.ruleHandle.getSetHeaders();
                setHeaderMap.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1));
            }
            if (MapUtils.isNotEmpty((Map)this.ruleHandle.getReplaceHeaderKeys())) {
                Map replaceHeaderMap = this.ruleHandle.getReplaceHeaderKeys();
                replaceHeaderMap.forEach((key, value) -> {
                    List cfr_ignored_0 = (List)httpHeaders.replace(key, Collections.singletonList(value));
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)this.ruleHandle.getRemoveHeaderKeys())) {
                Set removeHeaderList = this.ruleHandle.getRemoveHeaderKeys();
                removeHeaderList.forEach(arg_0 -> ((HttpHeaders)httpHeaders).remove(arg_0));
            }
            if (this.ruleHandle.getStatusCode() > 0) {
                this.setStatusCode(HttpStatus.valueOf((int)this.ruleHandle.getStatusCode()));
            }
            this.getDelegate().getHeaders().clear();
            this.getDelegate().getHeaders().putAll((Map)httpHeaders);
        }

        private byte[] modifyBody(byte[] responseBody) {
            try {
                String bodyStr = this.modifyBody(new String(responseBody, StandardCharsets.UTF_8));
                LOG.info("the body string {}", (Object)bodyStr);
                return bodyStr.getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOG.error("modify response error", (Throwable)e);
                throw new ShenyuException(String.format("response modify failure. %s", e.getLocalizedMessage()));
            }
        }

        private String modifyBody(String jsonValue) {
            DocumentContext context = JsonPath.parse((String)jsonValue);
            if (CollectionUtils.isNotEmpty((Collection)this.ruleHandle.getAddBodyKeys())) {
                this.ruleHandle.getAddBodyKeys().forEach(info -> context.put(info.getPath(), info.getKey(), (Object)info.getValue(), new Predicate[0]));
            }
            if (CollectionUtils.isNotEmpty((Collection)this.ruleHandle.getReplaceBodyKeys())) {
                this.ruleHandle.getReplaceBodyKeys().forEach(info -> context.renameKey(info.getPath(), info.getKey(), info.getValue(), new Predicate[0]));
            }
            if (CollectionUtils.isNotEmpty((Collection)this.ruleHandle.getRemoveBodyKeys())) {
                this.ruleHandle.getRemoveBodyKeys().forEach(x$0 -> context.delete(x$0, new Predicate[0]));
            }
            return context.jsonString();
        }
    }
}

