/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.handler;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.RateLimiterHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cache.redis.RedisConfigProperties;
import org.apache.shenyu.plugin.cache.redis.RedisConnectionFactory;
import org.apache.shenyu.plugin.cache.redis.serializer.ShenyuRedisSerializationContext;
import org.apache.shenyu.plugin.ratelimiter.handler.ShenyuReactiveRedisTemplate;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;

public class RateLimiterPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, RateLimiterHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            RedisConfigProperties redisConfigProperties = (RedisConfigProperties)GsonUtils.getInstance().fromJson(pluginData.getConfig(), RedisConfigProperties.class);
            if (Objects.isNull(Singleton.INST.get(ReactiveRedisTemplate.class)) || Objects.isNull(Singleton.INST.get(RedisConfigProperties.class)) || !redisConfigProperties.equals(Singleton.INST.get(RedisConfigProperties.class))) {
                RedisConnectionFactory redisConnectionFactory = new RedisConnectionFactory(redisConfigProperties);
                ShenyuReactiveRedisTemplate reactiveRedisTemplate = new ShenyuReactiveRedisTemplate((ReactiveRedisConnectionFactory)redisConnectionFactory.getLettuceConnectionFactory(), ShenyuRedisSerializationContext.stringSerializationContext());
                Singleton.INST.single(ReactiveRedisTemplate.class, reactiveRedisTemplate);
                Singleton.INST.single(RedisConfigProperties.class, (Object)redisConfigProperties);
            }
        }
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            RateLimiterHandle rateLimiterHandle = (RateLimiterHandle)GsonUtils.getInstance().fromJson(s, RateLimiterHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)rateLimiterHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.RATE_LIMITER.getName();
    }
}

