/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response.strategy;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public class NettyClientMessageWriter
implements MessageWriter {
    private final List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, MediaType.APPLICATION_NDJSON);

    @Override
    public Mono<Void> writeWith(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange).doOnError(throwable -> this.cleanup(exchange)).then(Mono.defer(() -> {
            Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
            if (Objects.isNull(connection)) {
                Object error2 = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error2);
            }
            ServerHttpResponse response = exchange.getResponse();
            NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
            Flux body = connection.inbound().receive().retain().map(arg_0 -> ((NettyDataBufferFactory)factory).wrap(arg_0));
            MediaType contentType = response.getHeaders().getContentType();
            Mono responseMono = this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
            exchange.getAttributes().put("RESPONSE_MONO", responseMono);
            Consumer consumer = (Consumer)exchange.getAttribute("WATCHER_HTTP_STATUS");
            Optional.ofNullable(consumer).ifPresent(c -> c.accept(response.getStatusCode()));
            return responseMono.onErrorResume(error -> NettyClientMessageWriter.releaseIfNotConsumed((Flux<NettyDataBuffer>)body, error));
        })).doOnCancel(() -> this.cleanup(exchange));
    }

    @Override
    public List<String> supportTypes() {
        return Lists.newArrayList((Object[])new String[]{RpcTypeEnum.HTTP.getName(), RpcTypeEnum.SPRING_CLOUD.getName(), RpcTypeEnum.WEB_SOCKET.getName()});
    }

    private void cleanup(ServerWebExchange exchange) {
        Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
        if (Objects.nonNull(connection)) {
            connection.dispose();
        }
    }

    private static <T> Mono<T> releaseIfNotConsumed(Flux<NettyDataBuffer> dataBufferDody, Throwable ex) {
        return dataBufferDody != null ? dataBufferDody.map(DataBufferUtils::release).then(Mono.error((Throwable)ex)) : Mono.error((Throwable)ex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (!Objects.nonNull(contentType)) return false;
        if (!this.streamingMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) return false;
        return true;
    }
}

