/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.loadbalance.ShenyuSpringCloudServiceChooser;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringCloudPlugin
extends AbstractShenyuPlugin {
    private final ShenyuSpringCloudServiceChooser serviceChooser;
    private final SpringCloudRuleHandle defaultRuleHandle = new SpringCloudRuleHandle();

    public SpringCloudPlugin(ShenyuSpringCloudServiceChooser serviceInstanceChooser) {
        this.serviceChooser = serviceInstanceChooser;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        if (Objects.isNull(rule)) {
            return Mono.empty();
        }
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)SpringCloudPluginDataHandler.SELECTOR_CACHED.get().obtainHandle((Object)selector.getId());
        SpringCloudRuleHandle ruleHandle = this.buildRuleHandle(rule);
        String serviceId = springCloudSelectorHandle.getServiceId();
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        Upstream upstream = this.serviceChooser.choose(serviceId, selector.getId(), ip, ruleHandle.getLoadBalance());
        if (Objects.isNull(upstream)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String domain = upstream.buildDomain();
        this.setDomain(URI.create(domain + shenyuContext.getRealUrl()), exchange);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.SPRING_CLOUD.getCode();
    }

    public String named() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.SPRING_CLOUD});
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    private SpringCloudRuleHandle buildRuleHandle(RuleData rule) {
        return (SpringCloudRuleHandle)SpringCloudPluginDataHandler.RULE_CACHED.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
    }

    private void setDomain(URI uri, ServerWebExchange exchange) {
        String domain = uri.getScheme() + "://" + uri.getAuthority();
        exchange.getAttributes().put("httpDomain", domain);
    }
}

