/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud.listener;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.plugin.springcloud.cache.ServiceInstanceCache;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationListener;

public class SpringCloudHeartBeatListener
implements ApplicationListener<HeartbeatEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SpringCloudHeartBeatListener.class);
    private final DiscoveryClient discoveryClient;
    private final ShenyuConfig.SpringCloudCacheConfig cacheConfig;

    public SpringCloudHeartBeatListener(DiscoveryClient discoveryClient, ShenyuConfig.SpringCloudCacheConfig cacheConfig) {
        this.discoveryClient = discoveryClient;
        this.cacheConfig = cacheConfig;
    }

    public void onApplicationEvent(HeartbeatEvent event) {
        if (!this.cacheConfig.getEnabled().booleanValue()) {
            return;
        }
        LogUtils.debug((Logger)LOG, (String)"shenyu receive spring cloud heartbeat event", (Object[])new Object[0]);
        ConcurrentHashMap map = SpringCloudPluginDataHandler.SELECTOR_CACHED.get().getAllCache();
        if (MapUtils.isEmpty((Map)map)) {
            return;
        }
        map.forEach((key, value) -> {
            String serviceId = value.getServiceId();
            List serviceInstanceList = this.discoveryClient.getInstances(serviceId);
            ServiceInstanceCache.cacheServiceInstance(serviceId, serviceInstanceList);
        });
    }
}

