/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.uri;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.utils.RequestUrlUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class URIPlugin
implements ShenyuPlugin {
    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        String domain = (String)exchange.getAttribute("httpDomain");
        if (StringUtils.isBlank((CharSequence)domain)) {
            return chain.execute(exchange);
        }
        URI uri = RequestUrlUtils.buildRequestUri((ServerWebExchange)exchange, (String)domain);
        exchange.getAttributes().put("httpUri", uri);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.URI.getCode();
    }

    public String named() {
        return PluginEnum.URI.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }
}

