/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.gateway;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.api.RemoteAddressResolver;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.base.RpcParamTransformPlugin;
import org.apache.shenyu.plugin.base.cache.CommonMetaDataSubscriber;
import org.apache.shenyu.plugin.base.cache.CommonPluginDataSubscriber;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.web.configuration.ErrorHandlerConfiguration;
import org.apache.shenyu.web.configuration.ShenyuExtConfiguration;
import org.apache.shenyu.web.configuration.SpringExtConfiguration;
import org.apache.shenyu.web.filter.CrossFilter;
import org.apache.shenyu.web.filter.ExcludeFilter;
import org.apache.shenyu.web.filter.FallbackFilter;
import org.apache.shenyu.web.filter.FileSizeFilter;
import org.apache.shenyu.web.filter.HealthFilter;
import org.apache.shenyu.web.filter.LocalDispatcherFilter;
import org.apache.shenyu.web.forward.ForwardedRemoteAddressResolver;
import org.apache.shenyu.web.handler.ShenyuWebHandler;
import org.apache.shenyu.web.loader.ShenyuLoaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.WebFilter;

@Configuration
@ComponentScan(value={"org.apache.shenyu"})
@AutoConfigureBefore(value={SpringExtConfiguration.class})
@Import(value={ErrorHandlerConfiguration.class})
@AutoConfigureAfter(value={ShenyuExtConfiguration.class})
public class ShenyuConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuConfiguration.class);

    @Bean(value={"webHandler"})
    public ShenyuWebHandler shenyuWebHandler(ObjectProvider<List<ShenyuPlugin>> plugins, ShenyuConfig config) {
        List pluginList = (List)plugins.getIfAvailable(Collections::emptyList);
        List<ShenyuPlugin> shenyuPlugins = pluginList.stream().sorted(Comparator.comparingInt(ShenyuPlugin::getOrder)).collect(Collectors.toList());
        shenyuPlugins.forEach(shenyuPlugin -> LOG.info("load plugin:[{}] [{}]", (Object)shenyuPlugin.named(), (Object)shenyuPlugin.getClass().getName()));
        return new ShenyuWebHandler(shenyuPlugins, config);
    }

    @Bean(value={"dispatcherHandler"})
    public DispatcherHandler dispatcherHandler() {
        return new DispatcherHandler();
    }

    @Bean
    public ShenyuPlugin paramTransformPlugin() {
        return new RpcParamTransformPlugin();
    }

    @Bean
    public PluginDataSubscriber pluginDataSubscriber(ObjectProvider<List<PluginDataHandler>> pluginDataHandlerList, ApplicationEventPublisher eventPublisher) {
        return new CommonPluginDataSubscriber((List)pluginDataHandlerList.getIfAvailable(Collections::emptyList), eventPublisher);
    }

    @Bean
    public MetaDataSubscriber commonMetaDataSubscriber(ObjectProvider<List<MetaDataHandler>> metaDataHandlerList) {
        return new CommonMetaDataSubscriber((List)metaDataHandlerList.getIfAvailable(Collections::emptyList));
    }

    @Bean
    public ShenyuLoaderService shenyuLoaderService(ShenyuWebHandler shenyuWebHandler, PluginDataSubscriber pluginDataSubscriber, ShenyuConfig config) {
        return new ShenyuLoaderService(shenyuWebHandler, (CommonPluginDataSubscriber)pluginDataSubscriber, config);
    }

    @Bean
    @ConditionalOnMissingBean(value={RemoteAddressResolver.class})
    public RemoteAddressResolver remoteAddressResolver() {
        return new ForwardedRemoteAddressResolver(1);
    }

    @Bean
    @Order(value=-200)
    @ConditionalOnProperty(name={"shenyu.local.enabled"}, havingValue="true", matchIfMissing=true)
    public WebFilter localDispatcherFilter(DispatcherHandler dispatcherHandler, ShenyuConfig shenyuConfig) {
        return new LocalDispatcherFilter(dispatcherHandler, shenyuConfig.getLocal().getSha512Key());
    }

    @Bean
    @Order(value=-100)
    @ConditionalOnProperty(name={"shenyu.cross.enabled"}, havingValue="true")
    public WebFilter crossFilter(ShenyuConfig shenyuConfig) {
        return new CrossFilter(shenyuConfig.getCross());
    }

    @Bean
    @Order(value=-10)
    @ConditionalOnProperty(name={"shenyu.file.enabled"}, havingValue="true")
    public WebFilter fileSizeFilter(ShenyuConfig shenyuConfig) {
        return new FileSizeFilter(shenyuConfig.getFile().getMaxSize().intValue());
    }

    @Bean
    @Order(value=-5)
    @ConditionalOnProperty(name={"shenyu.exclude.enabled"}, havingValue="true")
    public WebFilter excludeFilter(ShenyuConfig shenyuConfig) {
        return new ExcludeFilter(shenyuConfig.getExclude().getPaths());
    }

    @Bean
    @Order(value=-5)
    @ConditionalOnProperty(name={"shenyu.fallback.enabled"}, havingValue="true")
    public WebFilter fallbackFilter(ShenyuConfig shenyuConfig, DispatcherHandler dispatcherHandler) {
        return new FallbackFilter(shenyuConfig.getFallback().getPaths(), dispatcherHandler);
    }

    @Bean
    @Order(value=-99)
    @ConditionalOnProperty(name={"shenyu.health.enabled"}, havingValue="true")
    public WebFilter healthFilter(ShenyuConfig shenyuConfig) {
        return new HealthFilter(shenyuConfig.getHealth().getPaths());
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu")
    public ShenyuConfig shenyuConfig() {
        return new ShenyuConfig();
    }
}

