/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.netty;

import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.util.AsyncMapping;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.shenyu.common.config.NettyHttpProperties;
import org.apache.shenyu.common.config.ssl.ShenyuSniAsyncMapping;
import org.apache.shenyu.common.config.ssl.SslCrtAndKey;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyFile;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.http.server.HttpServer;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpSslContextSpec;

@Configuration
public class ShenyuNettyWebServerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuNettyWebServerConfiguration.class);

    @Bean
    @ConfigurationProperties(prefix="shenyu.netty.http")
    public NettyHttpProperties nettyTcpProperties() {
        return new NettyHttpProperties();
    }

    @Bean
    @ConditionalOnProperty(value={"shenyu.netty.http.web-server-factory-enabled", "shenyu.netty.http.sni.enabled"}, havingValue="true")
    public ShenyuSniAsyncMapping shenyuSniAsyncMapping() {
        return new ShenyuSniAsyncMapping();
    }

    @Bean
    @ConditionalOnProperty(value={"shenyu.netty.http.web-server-factory-enabled"}, havingValue="true", matchIfMissing=true)
    public NettyReactiveWebServerFactory nettyReactiveWebServerFactory(ObjectProvider<NettyHttpProperties> properties, ObjectProvider<ShenyuSniAsyncMapping> shenyuSniAsyncMappingProvider, ObjectProvider<TcpSslContextSpec> tcpSslContextSpecs) {
        NettyReactiveWebServerFactory webServerFactory = new NettyReactiveWebServerFactory();
        NettyHttpProperties nettyHttpProperties = (NettyHttpProperties)Optional.ofNullable(properties.getIfAvailable()).orElse(new NettyHttpProperties());
        webServerFactory.addServerCustomizers(new NettyServerCustomizer[]{new EventLoopNettyCustomizer(nettyHttpProperties, httpServer -> {
            NettyHttpProperties.SniProperties sniProperties = nettyHttpProperties.getSni();
            if (sniProperties.getEnabled().booleanValue()) {
                ShenyuSniAsyncMapping shenyuSniAsyncMapping = (ShenyuSniAsyncMapping)shenyuSniAsyncMappingProvider.getIfAvailable();
                if (shenyuSniAsyncMapping == null) {
                    throw new ShenyuException("Can not find shenyuSniAsyncMapping bean");
                }
                if ("manual".equals(sniProperties.getMod())) {
                    if (sniProperties.getCertificates() == null || sniProperties.getCertificates().isEmpty()) {
                        throw new ShenyuException("At least one certificate is required");
                    }
                    List certificates = sniProperties.getCertificates();
                    for (SslCrtAndKeyFile certificate : certificates) {
                        try {
                            shenyuSniAsyncMapping.addSslCertificate((SslCrtAndKey)certificate);
                        }
                        catch (IOException e) {
                            LOG.error("add certificate error", (Throwable)e);
                        }
                    }
                    SslCrtAndKeyFile defaultCert = (SslCrtAndKeyFile)certificates.get(0);
                    TcpSslContextSpec defaultSpec = TcpSslContextSpec.forServer((File)new File(defaultCert.getKeyCertChainFile()), (File)new File(defaultCert.getKeyFile()));
                    httpServer = httpServer.secure(spec -> spec.sslContext((SslProvider.ProtocolSslContextSpec)defaultSpec).setSniAsyncMappings((AsyncMapping)shenyuSniAsyncMapping), false);
                } else if ("k8s".equals(sniProperties.getMod())) {
                    TcpSslContextSpec defaultSpec = (TcpSslContextSpec)Objects.requireNonNull(tcpSslContextSpecs.getIfAvailable());
                    httpServer = httpServer.secure(spec -> spec.sslContext((SslProvider.ProtocolSslContextSpec)defaultSpec).setSniAsyncMappings((AsyncMapping)shenyuSniAsyncMapping), false);
                    shenyuSniAsyncMapping.addSslProvider("shenyu-default", SslProvider.builder().sslContext((SslProvider.ProtocolSslContextSpec)defaultSpec).build());
                } else {
                    throw new ShenyuException("Cannot read the sni mod");
                }
            }
            return httpServer;
        })});
        return webServerFactory;
    }

    private static class EventLoopNettyCustomizer
    implements NettyServerCustomizer {
        private final NettyHttpProperties nettyHttpProperties;
        private final Function<HttpServer, HttpServer> sniProcessor;

        EventLoopNettyCustomizer(NettyHttpProperties nettyHttpProperties, Function<HttpServer, HttpServer> sniProcessor) {
            this.nettyHttpProperties = nettyHttpProperties;
            this.sniProcessor = sniProcessor;
        }

        public HttpServer apply(HttpServer httpServer) {
            return (HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)((HttpServer)this.sniProcessor.apply(httpServer).runOn(LoopResources.create((String)"shenyu-netty", (int)this.nettyHttpProperties.getSelectCount(), (int)this.nettyHttpProperties.getWorkerCount(), (boolean)true))).accessLog(this.nettyHttpProperties.getAccessLog().booleanValue()).option(ChannelOption.SO_BACKLOG, (Object)this.nettyHttpProperties.getServerSocketChannel().getSoBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)this.nettyHttpProperties.getServerSocketChannel().isSoReuseAddr())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyHttpProperties.getServerSocketChannel().getSoRcvBuf())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyHttpProperties.getServerSocketChannel().getConnectTimeoutMillis())).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyHttpProperties.getServerSocketChannel().getWriteBufferLowWaterMark().intValue(), this.nettyHttpProperties.getServerSocketChannel().getWriteBufferHighWaterMark().intValue()))).option(ChannelOption.WRITE_SPIN_COUNT, (Object)this.nettyHttpProperties.getServerSocketChannel().getWriteSpinCount())).option(ChannelOption.AUTO_READ, (Object)this.nettyHttpProperties.getServerSocketChannel().isAutoRead())).option(ChannelOption.ALLOCATOR, (Object)this.nettyHttpProperties.getServerSocketChannel().getAllocator())).option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)this.nettyHttpProperties.getServerSocketChannel().getMessageSizeEstimatorBuild())).option(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP, (Object)this.nettyHttpProperties.getServerSocketChannel().getSingleEventExecutorPerGroup())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.nettyHttpProperties.getSocketChannel().isSoKeepAlive())).childOption(ChannelOption.SO_LINGER, (Object)this.nettyHttpProperties.getSocketChannel().getSoLinger())).childOption(ChannelOption.TCP_NODELAY, (Object)this.nettyHttpProperties.getSocketChannel().isTcpNoDelay())).childOption(ChannelOption.SO_SNDBUF, (Object)this.nettyHttpProperties.getSocketChannel().getSoSndBuf())).childOption(ChannelOption.IP_TOS, (Object)this.nettyHttpProperties.getSocketChannel().getIpTos())).childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)this.nettyHttpProperties.getSocketChannel().isAllowHalfClosure())).childOption(ChannelOption.SO_RCVBUF, (Object)this.nettyHttpProperties.getSocketChannel().getSoRcvBuf())).childOption(ChannelOption.SO_REUSEADDR, (Object)this.nettyHttpProperties.getSocketChannel().isSoReuseAddr())).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyHttpProperties.getSocketChannel().getConnectTimeoutMillis())).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyHttpProperties.getSocketChannel().getWriteBufferLowWaterMark().intValue(), this.nettyHttpProperties.getSocketChannel().getWriteBufferHighWaterMark().intValue()))).childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)this.nettyHttpProperties.getSocketChannel().getWriteSpinCount())).childOption(ChannelOption.AUTO_READ, (Object)this.nettyHttpProperties.getSocketChannel().isAutoRead())).childOption(ChannelOption.ALLOCATOR, (Object)this.nettyHttpProperties.getSocketChannel().getAllocator())).childOption(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)this.nettyHttpProperties.getSocketChannel().getMessageSizeEstimatorBuild())).childOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP, (Object)this.nettyHttpProperties.getSocketChannel().getSingleEventExecutorPerGroup());
        }
    }
}

