/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sync.data.http;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.constant.HttpConstants;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.http.AccessTokenManager;
import org.apache.shenyu.sync.data.http.HttpSyncDataService;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={HttpSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.http", name={"url"})
@EnableConfigurationProperties(value={HttpConfig.class})
public class HttpSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSyncDataConfiguration.class);

    @Bean
    public RestTemplate restTemplate(HttpConfig httpConfig) {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory();
        factory.setConnectTimeout(Objects.isNull(httpConfig.getConnectionTimeout()) ? (int)HttpConstants.CLIENT_POLLING_CONNECT_TIMEOUT : httpConfig.getConnectionTimeout());
        factory.setReadTimeout(Objects.isNull(httpConfig.getReadTimeout()) ? (int)HttpConstants.CLIENT_POLLING_READ_TIMEOUT : httpConfig.getReadTimeout());
        factory.setWriteTimeout(Objects.isNull(httpConfig.getWriteTimeout()) ? (int)HttpConstants.CLIENT_POLLING_WRITE_TIMEOUT : httpConfig.getWriteTimeout());
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    public AccessTokenManager accessTokenManager(HttpConfig httpConfig, RestTemplate restTemplate) {
        return new AccessTokenManager(restTemplate, httpConfig);
    }

    @Bean
    public SyncDataService httpSyncDataService(ObjectProvider<HttpConfig> httpConfig, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<RestTemplate> restTemplate, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<AccessTokenManager> accessTokenManager) {
        LOGGER.info("you use http long pull sync shenyu data");
        return new HttpSyncDataService((HttpConfig)Objects.requireNonNull(httpConfig.getIfAvailable()), (PluginDataSubscriber)Objects.requireNonNull(pluginSubscriber.getIfAvailable()), (RestTemplate)Objects.requireNonNull(restTemplate.getIfAvailable()), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (AccessTokenManager)Objects.requireNonNull(accessTokenManager.getIfAvailable()));
    }
}

