/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sync.data.websocket;

import java.util.Collections;
import java.util.List;
import org.apache.shenyu.plugin.sync.data.websocket.WebsocketSyncDataService;
import org.apache.shenyu.plugin.sync.data.websocket.config.WebsocketConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={WebsocketSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.websocket", name={"urls"})
public class WebsocketSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketSyncDataConfiguration.class);

    @Bean
    public SyncDataService websocketSyncDataService(ObjectProvider<WebsocketConfig> websocketConfig, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorSubscribers, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamSubscribers) {
        LOGGER.info("you use websocket sync shenyu data.......");
        return new WebsocketSyncDataService((WebsocketConfig)websocketConfig.getIfAvailable(WebsocketConfig::new), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (List)proxySelectorSubscribers.getIfAvailable(Collections::emptyList), (List)discoveryUpstreamSubscribers.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.websocket")
    public WebsocketConfig websocketConfig() {
        return new WebsocketConfig();
    }
}

