/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.consul.handler;

import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulCacheHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulCacheHandler.class);
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public ConsulCacheHandler(PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
    }

    protected void updatePluginData(String configInfo) {
        try {
            ArrayList pluginDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, PluginData.class).values());
            pluginDataList.forEach(pluginData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unSubscribe(pluginData);
                subscriber.onSubscribe(pluginData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync plugin data have error:", (Throwable)e);
        }
    }

    protected void updateSelectorMap(String configInfo) {
        try {
            List<SelectorData> selectorDataList = GsonUtils.getInstance().toObjectMapList(configInfo, SelectorData.class).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            selectorDataList.forEach(selectorData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unSelectorSubscribe(selectorData);
                subscriber.onSelectorSubscribe(selectorData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync selector data have error:", (Throwable)e);
        }
    }

    protected void updateRuleMap(String configInfo) {
        try {
            List<RuleData> ruleDataList = GsonUtils.getInstance().toObjectMapList(configInfo, RuleData.class).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            ruleDataList.forEach(ruleData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unRuleSubscribe(ruleData);
                subscriber.onRuleSubscribe(ruleData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync rule data have error:", (Throwable)e);
        }
    }

    protected void updateMetaDataMap(String configInfo) {
        try {
            ArrayList metaDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, MetaData.class).values());
            metaDataList.forEach(metaData -> this.metaDataSubscribers.forEach(subscriber -> {
                subscriber.unSubscribe(metaData);
                subscriber.onSubscribe(metaData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync meta data have error:", (Throwable)e);
        }
    }

    protected void updateAuthMap(String configInfo) {
        try {
            ArrayList appAuthDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, AppAuthData.class).values());
            appAuthDataList.forEach(appAuthData -> this.authDataSubscribers.forEach(subscriber -> {
                subscriber.unSubscribe(appAuthData);
                subscriber.onSubscribe(appAuthData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync auth data have error:", (Throwable)e);
        }
    }

    protected static interface OnChange {
        public void change(String var1);
    }
}

