/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdClient.class);
    private final Client client;
    private final ConcurrentHashMap<String, Watch.Watcher> watchCache = new ConcurrentHashMap();

    public EtcdClient(Client client) {
        this.client = client;
    }

    public void close() {
        this.client.close();
    }

    public String get(String key) {
        List keyValues = null;
        try {
            keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).get()).getKvs();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (CollectionUtils.isEmpty(keyValues)) {
            return null;
        }
        return ((KeyValue)keyValues.iterator().next()).getValue().toString(StandardCharsets.UTF_8);
    }

    public List<String> getChildrenKeys(String prefix, String separator) throws ExecutionException, InterruptedException {
        ByteSequence prefixByteSequence = ByteSequence.from((String)prefix, (Charset)StandardCharsets.UTF_8);
        GetOption getOption = GetOption.newBuilder().withPrefix(prefixByteSequence).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build();
        List keyValues = ((GetResponse)this.client.getKVClient().get(prefixByteSequence, getOption).get()).getKvs();
        return keyValues.stream().map(e -> this.getSubNodeKeyName(prefix, e.getKey().toString(StandardCharsets.UTF_8), separator)).distinct().filter(e -> Objects.nonNull(e)).collect(Collectors.toList());
    }

    private String getSubNodeKeyName(String prefix, String fullPath, String separator) {
        if (prefix.length() > fullPath.length()) {
            return null;
        }
        String pathWithoutPrefix = fullPath.substring(prefix.length());
        return pathWithoutPrefix.contains(separator) ? pathWithoutPrefix.substring(1) : pathWithoutPrefix;
    }

    public void watchDataChange(String key, BiConsumer<String, String> updateHandler, Consumer<String> deleteHandler) {
        Watch.Listener listener = this.watch(updateHandler, deleteHandler);
        Watch.Watcher watch = this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), listener);
        this.watchCache.put(key, watch);
    }

    public void watchChildChange(String key, BiConsumer<String, String> updateHandler, Consumer<String> deleteHandler) {
        Watch.Listener listener = this.watch(updateHandler, deleteHandler);
        WatchOption option = WatchOption.newBuilder().withPrefix(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).build();
        Watch.Watcher watch = this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), option, listener);
        this.watchCache.put(key, watch);
    }

    private Watch.Listener watch(BiConsumer<String, String> updateHandler, Consumer<String> deleteHandler) {
        return Watch.listener(response -> {
            block4: for (WatchEvent event : response.getEvents()) {
                String path = event.getKeyValue().getKey().toString(StandardCharsets.UTF_8);
                String value = event.getKeyValue().getValue().toString(StandardCharsets.UTF_8);
                switch (event.getEventType()) {
                    case PUT: {
                        updateHandler.accept(path, value);
                        continue block4;
                    }
                    case DELETE: {
                        deleteHandler.accept(path);
                        continue block4;
                    }
                }
            }
        });
    }

    public void watchClose(String key) {
        if (this.watchCache.containsKey(key)) {
            this.watchCache.get(key).close();
            this.watchCache.remove(key);
        }
    }
}

