/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.etcd;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.core.AbstractPathDataSyncService;
import org.apache.shenyu.sync.data.etcd.EtcdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdSyncDataService
extends AbstractPathDataSyncService {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdSyncDataService.class);
    private final EtcdClient etcdClient;

    public EtcdSyncDataService(EtcdClient etcdClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        super(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers);
        this.etcdClient = etcdClient;
        this.watcherData();
    }

    private void watcherData() {
        this.watcherData0("/shenyu/plugin");
        this.watcherData0("/shenyu/selector");
        this.watcherData0("/shenyu/rule");
        this.watcherData0("/shenyu/proxySelectorData");
        this.watcherData0("/shenyu/discoveryUpstream");
        this.watcherData0("/shenyu/auth");
        this.watcherData0("/shenyu/metaData");
    }

    private void watcherData0(String registerPath) {
        this.etcdClient.watchChildChange(registerPath, (updatePath, updateValue) -> super.event(updatePath, updateValue, registerPath, AbstractPathDataSyncService.EventType.PUT), deletePath -> super.event(deletePath, null, registerPath, AbstractPathDataSyncService.EventType.DELETE));
        try {
            List<String> childrenKeys = this.etcdClient.getChildrenKeys(registerPath, "/");
            if (!ObjectUtils.isEmpty(childrenKeys)) {
                childrenKeys.forEach(nodePath -> {
                    String nodeData = this.etcdClient.get(String.join((CharSequence)"/", registerPath, nodePath));
                    super.event(nodePath, nodeData, registerPath, AbstractPathDataSyncService.EventType.PUT);
                });
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void close() {
        if (Objects.nonNull(this.etcdClient)) {
            this.etcdClient.close();
        }
    }
}

