/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.polaris;

import com.tencent.polaris.configuration.api.core.ChangeType;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileChangeListener;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.core.AbstractNodeDataSyncService;
import org.apache.shenyu.sync.data.polaris.config.PolarisConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisSyncDataService
extends AbstractNodeDataSyncService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisSyncDataService.class);
    private final PolarisConfig polarisConfig;
    private final ConfigFileService configFileService;
    private final Map<String, ConfigFileChangeListener> watchCache = new ConcurrentHashMap<String, ConfigFileChangeListener>();

    public PolarisSyncDataService(PolarisConfig polarisConfig, ConfigFileService configFileService, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        super(new AbstractNodeDataSyncService.ChangeData("plugin", "selector", "rule", "auth", "meta", "proxy.selector", "discovery"), pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers);
        this.polarisConfig = polarisConfig;
        this.configFileService = configFileService;
        this.startWatch();
    }

    protected String getServiceConfig(String key, Consumer<String> updateHandler, Consumer<String> deleteHandler) {
        if (this.watchCache.containsKey(key)) {
            return null;
        }
        try {
            ConfigFileChangeListener listener = event -> {
                try {
                    if (event.getChangeType().equals((Object)ChangeType.DELETED) || StringUtils.isBlank((CharSequence)event.getNewValue())) {
                        Optional.ofNullable(deleteHandler).ifPresent(deleteHandler2 -> deleteHandler2.accept(key));
                    } else {
                        if (event.getNewValue().equals(event.getOldValue())) {
                            return;
                        }
                        updateHandler.accept(event.getNewValue());
                    }
                }
                catch (Exception e) {
                    LOG.error("Polaris sync listener receiveConfigInfo error", (Throwable)e);
                }
            };
            ConfigFile configFile = this.configFileService.getConfigFile(this.polarisConfig.getNamespace(), this.polarisConfig.getFileGroup(), key);
            configFile.addChangeListener(listener);
            this.watchCache.put(key, listener);
            return configFile.hasContent() ? configFile.getContent() : null;
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    protected void doRemoveListener(String removeKey) {
        ConfigFileChangeListener configFileChangeListener = this.watchCache.get(removeKey);
        if (!Objects.isNull(configFileChangeListener)) {
            ConfigFile configFile = this.configFileService.getConfigFile(this.polarisConfig.getNamespace(), this.polarisConfig.getFileGroup(), removeKey);
            configFile.removeChangeListener(configFileChangeListener);
        }
    }

    public void close() {
        this.watchCache.forEach((key, configFileChangeListener) -> {
            if (!Objects.isNull(configFileChangeListener)) {
                ConfigFile configFile = this.configFileService.getConfigFile(this.polarisConfig.getNamespace(), this.polarisConfig.getFileGroup(), key);
                configFile.removeChangeListener(configFileChangeListener);
            }
        });
    }
}

