/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.zookeeper;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.core.AbstractPathDataSyncService;
import org.apache.shenyu.sync.data.zookeeper.ZookeeperClient;

public class ZookeeperSyncDataService
extends AbstractPathDataSyncService {
    private final ZookeeperClient zkClient;

    public ZookeeperSyncDataService(ZookeeperClient zkClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        super(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers);
        this.zkClient = zkClient;
        this.watcherData();
    }

    private void watcherData() {
        this.watcherData0("/shenyu/plugin");
        this.watcherData0("/shenyu/selector");
        this.watcherData0("/shenyu/rule");
        this.watcherData0("/shenyu/proxySelectorData");
        this.watcherData0("/shenyu/discoveryUpstream");
        this.watcherData0("/shenyu/auth");
        this.watcherData0("/shenyu/metaData");
    }

    private void watcherData0(String registerPath) {
        this.zkClient.addCache(registerPath, (curatorFramework, treeCacheEvent) -> {
            ChildData childData = treeCacheEvent.getData();
            if (null == childData) {
                return;
            }
            String path = childData.getPath();
            if (Strings.isNullOrEmpty((String)path)) {
                return;
            }
            if (!path.contains(registerPath)) {
                return;
            }
            AbstractPathDataSyncService.EventType eventType = treeCacheEvent.getType().equals((Object)TreeCacheEvent.Type.NODE_REMOVED) ? AbstractPathDataSyncService.EventType.DELETE : AbstractPathDataSyncService.EventType.PUT;
            String updateData = childData.getData() != null ? new String(childData.getData(), StandardCharsets.UTF_8) : null;
            this.event(path, updateData, registerPath, eventType);
        });
    }

    public void close() {
        if (Objects.nonNull(this.zkClient)) {
            this.zkClient.close();
        }
    }
}

