/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.configuration;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shenyu.plugin.api.RemoteAddressResolver;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.base.ParamTransformPlugin;
import org.apache.shenyu.plugin.base.cache.CommonPluginDataSubscriber;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.web.configuration.ErrorHandlerConfiguration;
import org.apache.shenyu.web.configuration.ShenyuExtConfiguration;
import org.apache.shenyu.web.configuration.SpringExtConfiguration;
import org.apache.shenyu.web.configuration.properties.ExcludePathProperties;
import org.apache.shenyu.web.configuration.properties.ShenyuConfig;
import org.apache.shenyu.web.filter.CrossFilter;
import org.apache.shenyu.web.filter.ExcludeFilter;
import org.apache.shenyu.web.filter.FileSizeFilter;
import org.apache.shenyu.web.filter.TimeWebFilter;
import org.apache.shenyu.web.filter.WebSocketParamFilter;
import org.apache.shenyu.web.forward.ForwardedRemoteAddressResolver;
import org.apache.shenyu.web.handler.ShenyuWebHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.WebFilter;

@Configuration
@ComponentScan(value={"org.apache.shenyu"})
@Import(value={ErrorHandlerConfiguration.class, ShenyuExtConfiguration.class, SpringExtConfiguration.class})
public class ShenyuConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShenyuConfiguration.class);

    @Bean(value={"webHandler"})
    public ShenyuWebHandler shenyuWebHandler(ObjectProvider<List<ShenyuPlugin>> plugins) {
        List pluginList = (List)plugins.getIfAvailable(Collections::emptyList);
        List<ShenyuPlugin> shenyuPlugins = pluginList.stream().sorted(Comparator.comparingInt(ShenyuPlugin::getOrder)).collect(Collectors.toList());
        shenyuPlugins.forEach(shenyuPlugin -> log.info("load plugin:[{}] [{}]", (Object)shenyuPlugin.named(), (Object)shenyuPlugin.getClass().getName()));
        return new ShenyuWebHandler(shenyuPlugins);
    }

    @Bean(value={"dispatcherHandler"})
    public DispatcherHandler dispatcherHandler() {
        return new DispatcherHandler();
    }

    @Bean
    public ShenyuPlugin paramTransformPlugin() {
        return new ParamTransformPlugin();
    }

    @Bean
    public PluginDataSubscriber pluginDataSubscriber(ObjectProvider<List<PluginDataHandler>> pluginDataHandlerList) {
        return new CommonPluginDataSubscriber((List)pluginDataHandlerList.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConditionalOnMissingBean(value={RemoteAddressResolver.class})
    public RemoteAddressResolver remoteAddressResolver() {
        return new ForwardedRemoteAddressResolver(1);
    }

    @Bean
    @Order(value=-100)
    @ConditionalOnProperty(name={"shenyu.cross.enabled"}, havingValue="true")
    public WebFilter crossFilter() {
        return new CrossFilter();
    }

    @Bean
    @Order(value=-10)
    @ConditionalOnProperty(name={"shenyu.file.enabled"}, havingValue="true")
    public WebFilter fileSizeFilter(ShenyuConfig shenyuConfig) {
        return new FileSizeFilter(shenyuConfig.getFileMaxSize());
    }

    @Bean
    @Order(value=-5)
    @ConditionalOnProperty(name={"shenyu.exclude.enabled"}, havingValue="true")
    public WebFilter excludeFilter(ExcludePathProperties excludePathProperties) {
        return new ExcludeFilter(excludePathProperties);
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu")
    public ShenyuConfig shenyuConfig() {
        return new ShenyuConfig();
    }

    @Bean
    @Order(value=30)
    @ConditionalOnProperty(name={"shenyu.filterTimeEnable"})
    public WebFilter timeWebFilter(ShenyuConfig shenyuConfig) {
        return new TimeWebFilter(shenyuConfig);
    }

    @Bean
    @Order(value=4)
    public WebFilter webSocketWebFilter() {
        return new WebSocketParamFilter();
    }
}

