/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.List;
import java.util.Map;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FileSizeFilter
implements WebFilter {
    private static final int BYTES_PER_MB = 0x100000;
    private final int fileMaxSize;
    private final List<HttpMessageReader<?>> messageReaders;

    public FileSizeFilter(int fileMaxSize) {
        HandlerStrategies handlerStrategies = HandlerStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(fileMaxSize * 0x100000)).build();
        this.messageReaders = handlerStrategies.messageReaders();
        this.fileMaxSize = fileMaxSize;
    }

    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        MediaType mediaType = exchange.getRequest().getHeaders().getContentType();
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType)) {
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
            return serverRequest.bodyToMono(DataBuffer.class).flatMap(size -> {
                if (size.capacity() > 0x100000 * this.fileMaxSize) {
                    ServerHttpResponse response = exchange.getResponse();
                    response.setStatusCode(HttpStatus.BAD_REQUEST);
                    Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.PAYLOAD_TOO_LARGE.getCode(), (String)ShenyuResultEnum.PAYLOAD_TOO_LARGE.getMsg(), null);
                    return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
                }
                BodyInserter bodyInsert = BodyInserters.fromPublisher((Publisher)Mono.just((Object)size), DataBuffer.class);
                HttpHeaders headers = new HttpHeaders();
                headers.putAll((Map)exchange.getRequest().getHeaders());
                headers.remove((Object)"Content-Length");
                CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
                return bodyInsert.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                    ServerHttpRequestDecorator decorator = this.decorate(exchange, outputMessage);
                    return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
                }));
            });
        }
        return chain.filter(exchange);
    }

    private ServerHttpRequestDecorator decorate(ServerWebExchange exchange, final CachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(exchange.getRequest()){

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }
        };
    }
}

