/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.web.filter.AbstractWebFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebSocketParamFilter
extends AbstractWebFilter {
    private static final String UPGRADE = "Upgrade";

    @Override
    protected Mono<Boolean> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        String upgrade = headers.getFirst(UPGRADE);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{upgrade}) && RpcTypeEnum.WEB_SOCKET.getName().equals(upgrade)) {
            return Mono.just((Object)this.verify((MultiValueMap<String, String>)request.getQueryParams()));
        }
        return Mono.just((Object)true);
    }

    @Override
    protected Mono<Void> doDenyResponse(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        Object error = ShenyuResultWrap.error((int)ShenyuResultEnum.PARAM_ERROR.getCode(), (String)ShenyuResultEnum.PARAM_ERROR.getMsg(), null);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    private Boolean verify(MultiValueMap<String, String> queryParams) {
        return !StringUtils.isBlank((CharSequence)((CharSequence)queryParams.getFirst((Object)"module"))) && !StringUtils.isBlank((CharSequence)((CharSequence)queryParams.getFirst((Object)"method"))) && !StringUtils.isBlank((CharSequence)((CharSequence)queryParams.getFirst((Object)"rpcType")));
    }
}

