/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.Map;
import lombok.Generated;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;

public class GlobalErrorHandler
extends DefaultErrorWebExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalErrorHandler.class);

    public GlobalErrorHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, boolean includeStackTrace) {
        this.logError(request);
        return this.response(request);
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> ((GlobalErrorHandler)this).renderErrorResponse(arg_0));
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        return HttpStatus.INTERNAL_SERVER_ERROR.value();
    }

    private Map<String, Object> response(ServerRequest request) {
        Throwable ex = this.getError(request);
        Object error = ShenyuResultWrap.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Object)ex.getMessage());
        return GsonUtils.getInstance().toObjectMap(GsonUtils.getInstance().toJson(error));
    }

    private void logError(ServerRequest request) {
        Throwable ex = this.getError(request);
        log.error(request.exchange().getLogPrefix() + this.formatError(ex, request));
    }

    private String formatError(Throwable ex, ServerRequest request) {
        String reason = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        return "Resolved [" + reason + "] for HTTP " + request.methodName() + " " + request.path();
    }
}

