/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ShenyuWebHandler
implements WebHandler {
    private final List<ShenyuPlugin> plugins;
    private final boolean scheduled;
    private Scheduler scheduler;

    public ShenyuWebHandler(List<ShenyuPlugin> plugins) {
        this.plugins = plugins;
        String enabled = System.getProperty("shenyu.scheduler.enabled", "false");
        this.scheduled = Boolean.parseBoolean(enabled);
        if (this.scheduled) {
            String schedulerType = System.getProperty("shenyu.scheduler.type", "fixed");
            if (Objects.equals(schedulerType, "fixed")) {
                int threads = Integer.parseInt(System.getProperty("shenyu.work.threads", "" + Math.max((Runtime.getRuntime().availableProcessors() << 1) + 1, 16)));
                this.scheduler = Schedulers.newParallel((String)"shenyu-work-threads", (int)threads);
            } else {
                this.scheduler = Schedulers.elastic();
            }
        }
    }

    public Mono<Void> handle(@NonNull ServerWebExchange exchange) {
        Mono<Void> execute = new DefaultShenyuPluginChain(this.plugins).execute(exchange);
        if (this.scheduled) {
            return execute.subscribeOn(this.scheduler);
        }
        return execute;
    }

    private static class DefaultShenyuPluginChain
    implements ShenyuPluginChain {
        private int index;
        private final List<ShenyuPlugin> plugins;

        DefaultShenyuPluginChain(List<ShenyuPlugin> plugins) {
            this.plugins = plugins;
        }

        public Mono<Void> execute(ServerWebExchange exchange) {
            return Mono.defer(() -> {
                if (this.index < this.plugins.size()) {
                    ShenyuPlugin plugin;
                    Boolean skip;
                    if ((skip = (plugin = this.plugins.get(this.index++)).skip(exchange)).booleanValue()) {
                        return this.execute(exchange);
                    }
                    return plugin.execute(exchange, (ShenyuPluginChain)this);
                }
                return Mono.empty();
            });
        }
    }
}

