/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.web.loader.PluginJarParser;
import org.apache.shenyu.web.loader.ShenyuPluginClassLoader;

public final class ShenyuPluginClassloaderHolder {
    private static final ShenyuPluginClassloaderHolder HOLDER = new ShenyuPluginClassloaderHolder();
    private final Map<String, ShenyuPluginClassLoader> pluginCache = new ConcurrentHashMap<String, ShenyuPluginClassLoader>();

    private ShenyuPluginClassloaderHolder() {
    }

    public static ShenyuPluginClassloaderHolder getSingleton() {
        return HOLDER;
    }

    public ShenyuPluginClassLoader createPluginClassLoader(PluginJarParser.PluginJar pluginJar) {
        ShenyuPluginClassLoader shenyuPluginClassLoader = new ShenyuPluginClassLoader(pluginJar);
        String jarKey = Optional.ofNullable(pluginJar.getAbsolutePath()).orElse(pluginJar.getJarKey());
        if (this.pluginCache.containsKey(jarKey)) {
            this.pluginCache.remove(jarKey).close();
        }
        this.pluginCache.put(jarKey, shenyuPluginClassLoader);
        return shenyuPluginClassLoader;
    }

    public void removePluginClassLoader(String jarKey) {
        if (this.pluginCache.containsKey(jarKey)) {
            this.pluginCache.remove(jarKey).close();
        }
    }
}

