/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import com.google.common.base.ReferenceType;
import com.google.common.collect.ReferenceMap;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.util.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftExpiringCache<K, V> {
    private final Cache<K, V> cache;
    private final ReferenceMap<V, Long> expirationTimes;
    private TimeSource timeSource;

    public SoftExpiringCache(Cache<K, V> cache) {
        this.cache = cache;
        this.expirationTimes = new ReferenceMap(ReferenceType.WEAK, ReferenceType.STRONG);
        this.timeSource = new TimeSource();
    }

    public CachedObject<V> getElement(K key) {
        V value = this.cache.getElement(key);
        if (value == null) {
            return null;
        }
        Long expiration = (Long)this.expirationTimes.get(value);
        if (expiration == null) {
            return null;
        }
        return new CachedObject(value, expiration < this.timeSource.currentTimeMillis());
    }

    public void addElement(K key, V value, long maxAge) {
        long now = this.timeSource.currentTimeMillis();
        this.cache.addElement(key, value);
        this.expirationTimes.put(value, (Object)(now + maxAge));
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CachedObject<V> {
        public final V obj;
        public final boolean isExpired;

        private CachedObject(V obj, boolean isExpired) {
            this.obj = obj;
            this.isExpired = isExpired;
        }
    }
}

