/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import java.util.EnumSet;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;

public class AnonymousSecurityToken
extends AbstractSecurityToken
implements SecurityToken {
    public static final String ANONYMOUS_ID = "-1";
    private static final EnumSet<AbstractSecurityToken.Keys> MAP_KEYS = EnumSet.of(AbstractSecurityToken.Keys.OWNER, new AbstractSecurityToken.Keys[]{AbstractSecurityToken.Keys.VIEWER, AbstractSecurityToken.Keys.APP_URL, AbstractSecurityToken.Keys.MODULE_ID, AbstractSecurityToken.Keys.EXPIRES, AbstractSecurityToken.Keys.TRUSTED_JSON});

    public AnonymousSecurityToken() {
        this("default");
    }

    public AnonymousSecurityToken(String container) {
        this(container, 0L, "", null);
    }

    public AnonymousSecurityToken(String container, Long moduleId, String appUrl, Long expiresAt) {
        this.setContainer(container).setModuleId(moduleId).setAppUrl(appUrl).setExpiresAt(expiresAt).setOwnerId(ANONYMOUS_ID).setViewerId(ANONYMOUS_ID).setDomain("*").setTrustedJson("");
    }

    @Override
    public String getAppId() {
        return this.getAppUrl();
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public String getUpdatedToken() {
        return "";
    }

    @Override
    public String getAuthenticationMode() {
        return AuthenticationMode.UNAUTHENTICATED.name();
    }

    @Override
    public String getActiveUrl() {
        throw new UnsupportedOperationException("No active URL available");
    }

    @Override
    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return MAP_KEYS;
    }
}

