/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.JsonProperty;
import org.json.JSONObject;

public final class JsonUtil {
    private static final Set<String> EXCLUDE_METHODS = ImmutableSet.of((Object)"getClass", (Object)"getDeclaringClass");
    private static final LoadingCache<Class<?>, Map<String, Method>> GETTERS = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Map<String, Method>>(){

        public Map<String, Method> load(Class<?> clazz) {
            ImmutableMap.Builder methods = ImmutableMap.builder();
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getParameterTypes().length != 0 || method.isSynthetic() || (name = JsonUtil.getPropertyName(method)) == null) continue;
                methods.put((Object)name, (Object)method);
            }
            return methods.build();
        }
    });

    private JsonUtil() {
    }

    public static Object getProperty(Object value, String propertyName) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)propertyName);
        if (value instanceof JSONObject) {
            return ((JSONObject)value).opt(propertyName);
        }
        if (value instanceof Map) {
            return ((Map)value).get(propertyName);
        }
        Method method = (Method)((Map)GETTERS.getUnchecked(value.getClass())).get(propertyName);
        if (method != null) {
            try {
                return method.invoke(value, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static Map<String, Method> getGetters(Object pojo) {
        return (Map)GETTERS.getUnchecked(pojo.getClass());
    }

    private static String getPropertyName(Method method) {
        JsonProperty property = method.getAnnotation(JsonProperty.class);
        if (property == null) {
            String name = method.getName();
            if (name.startsWith("get") && !EXCLUDE_METHODS.contains(name)) {
                return name.substring(3, 4).toLowerCase() + name.substring(4);
            }
            return null;
        }
        return property.value();
    }
}

