/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.shindig.protocol.conversion.xstream.NamespaceSet;
import org.apache.shindig.protocol.conversion.xstream.StackWriterWrapper;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;

public class StackDriver
implements HierarchicalStreamDriver {
    private HierarchicalStreamDriver parent;
    private WriterStack writerStack;
    private Map<String, NamespaceSet> namespaces;

    public StackDriver(HierarchicalStreamDriver parent, WriterStack writerStack, Map<String, NamespaceSet> map) {
        this.parent = parent;
        this.writerStack = writerStack;
        this.namespaces = map;
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        return this.parent.createReader(reader);
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        return this.parent.createReader(inputStream);
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        HierarchicalStreamWriter parentWriter = this.parent.createWriter(writer);
        return new StackWriterWrapper(parentWriter, this.writerStack, this.namespaces);
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        HierarchicalStreamWriter parentWriter = this.parent.createWriter(outputStream);
        return new StackWriterWrapper(parentWriter, this.writerStack, this.namespaces);
    }

    public HierarchicalStreamReader createReader(URL url) {
        return this.parent.createReader(url);
    }

    public HierarchicalStreamReader createReader(File file) {
        return this.parent.createReader(file);
    }
}

