/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.common.util.TimeSource;

public final class HttpUtil {
    private static int defaultTtl = 31536000;
    private static TimeSource timeSource;
    static final Pattern GET_REQUEST_CALLBACK_PATTERN;
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";

    private HttpUtil() {
    }

    public static void setTimeSource(TimeSource timeSource) {
        HttpUtil.timeSource = timeSource;
    }

    public static TimeSource getTimeSource() {
        return timeSource;
    }

    public static void setCachingHeaders(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, defaultTtl, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, boolean noProxy) {
        HttpUtil.setCachingHeaders(response, defaultTtl, noProxy);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl) {
        HttpUtil.setCachingHeaders(response, ttl, false);
    }

    public static void setNoCache(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, 0, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl, boolean noProxy) {
        for (Pair<String, String> header : HttpUtil.getCachingHeadersToSet(ttl, noProxy)) {
            response.setHeader((String)header.one, (String)header.two);
        }
    }

    public static List<Pair<String, String>> getCachingHeadersToSet(int ttl, boolean noProxy) {
        ArrayList cachingHeaders = Lists.newArrayListWithExpectedSize((int)3);
        cachingHeaders.add(Pair.of("Expires", DateUtil.formatRfc1123Date(timeSource.currentTimeMillis() + 1000L * (long)ttl)));
        if (ttl <= 0) {
            cachingHeaders.add(Pair.of("Pragma", "no-cache"));
            cachingHeaders.add(Pair.of("Cache-Control", "no-cache"));
        } else if (noProxy) {
            cachingHeaders.add(Pair.of("Cache-Control", "private,max-age=" + Integer.toString(ttl)));
        } else {
            cachingHeaders.add(Pair.of("Cache-Control", "public,max-age=" + Integer.toString(ttl)));
        }
        return cachingHeaders;
    }

    public static int getDefaultTtl() {
        return defaultTtl;
    }

    public static void setDefaultTtl(int defaultTtl) {
        HttpUtil.defaultTtl = defaultTtl;
    }

    public static boolean isJSONP(HttpServletRequest request) throws IllegalArgumentException {
        String callback = request.getParameter("callback");
        if (!"GET".equals(request.getMethod())) {
            return false;
        }
        if (callback == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)GET_REQUEST_CALLBACK_PATTERN.matcher(callback).matches(), (Object)("Wrong format for parameter 'callback' specified. Must match: " + GET_REQUEST_CALLBACK_PATTERN.toString()));
        return true;
    }

    public static void setCORSheader(HttpServletResponse resp, Collection<String> validOrigins) {
        if (validOrigins == null) {
            return;
        }
        for (String origin : validOrigins) {
            resp.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        }
    }

    static {
        HttpUtil.setTimeSource(new TimeSource());
        GET_REQUEST_CALLBACK_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z0-9_\\.]+");
    }
}

