/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCache;

public class LruCacheProvider
implements CacheProvider {
    private static final String classname = LruCacheProvider.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final int defaultCapacity;
    private final Injector injector;
    private final Map<String, Cache<?, ?>> caches = new MapMaker().makeMap();

    @Inject
    public LruCacheProvider(Injector injector, @Named(value="shindig.cache.lru.default.capacity") int defaultCapacity) {
        this.injector = injector;
        this.defaultCapacity = defaultCapacity;
    }

    public LruCacheProvider(int capacity) {
        this(null, capacity);
    }

    private int getCapacity(String name) {
        block8: {
            if (this.injector != null && name != null) {
                String key = "shindig.cache.lru." + name + ".capacity";
                Key guiceKey = Key.get(String.class, (Annotation)Names.named((String)key));
                try {
                    if (this.injector.getBinding(guiceKey) == null) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.logp(Level.WARNING, classname, "getCapacity(String name)", "LRUCapacity", new Object[]{"No", name});
                        }
                        break block8;
                    }
                    String value = (String)this.injector.getInstance(guiceKey);
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.logp(Level.WARNING, classname, "getCapacity(String name)", "LRUCapacity", new Object[]{"Invalid", name});
                        }
                    }
                }
                catch (ConfigurationException e) {
                    return this.defaultCapacity;
                }
            }
        }
        return this.defaultCapacity;
    }

    @Override
    public <K, V> Cache<K, V> createCache(String name) {
        int capacity = this.getCapacity((String)Preconditions.checkNotNull((Object)name));
        Cache<?, ?> cache = this.caches.get(name);
        if (cache == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating cache named " + name);
            }
            cache = new LruCache(capacity);
            this.caches.put(name, cache);
        }
        return cache;
    }
}

