/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.shindig.protocol.RestfulCollection;

public final class FutureUtil {
    private FutureUtil() {
    }

    public static <T> Future<T> getFirstFromCollection(final Future<RestfulCollection<T>> collection) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return collection.cancel(mayInterruptIfRunning);
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return this.getFirstFromCollection((RestfulCollection)collection.get());
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.getFirstFromCollection((RestfulCollection)collection.get(timeout, unit));
            }

            @Override
            public boolean isCancelled() {
                return collection.isCancelled();
            }

            @Override
            public boolean isDone() {
                return collection.isDone();
            }

            private T getFirstFromCollection(RestfulCollection<T> collection2) {
                if (collection2.getTotalResults() > 0) {
                    return collection2.getList().get(0);
                }
                return null;
            }
        };
    }
}

