/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.util.JsonConversionUtil;
import org.apache.shindig.protocol.ApiServlet;
import org.apache.shindig.protocol.ContentTypes;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ResponseItem;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.protocol.multipart.MultipartFormParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcServlet
extends ApiServlet {
    public static final Set<String> ALLOWED_CONTENT_TYPES = new ImmutableSet.Builder().addAll(ContentTypes.ALLOWED_JSON_CONTENT_TYPES).addAll(ContentTypes.ALLOWED_MULTIPART_CONTENT_TYPES).build();
    public static final String REQUEST_PARAM = "request";
    private MultipartFormParser formParser;
    private String jsonRpcResultField = "result";
    private boolean jsonRpcBothFields = false;
    protected static final Map<Integer, String> errorTitles = ImmutableMap.builder().put((Object)501, (Object)"notImplemented").put((Object)401, (Object)"unauthorized").put((Object)403, (Object)"forbidden").put((Object)400, (Object)"badRequest").put((Object)500, (Object)"internalError").put((Object)417, (Object)"limitExceeded").build();

    @Inject
    void setMultipartFormParser(MultipartFormParser formParser) {
        this.formParser = formParser;
    }

    @Inject(optional=true)
    void setJsonRpcResultField(@Named(value="shindig.json-rpc.result-field") String jsonRpcResultField) {
        this.jsonRpcResultField = jsonRpcResultField;
        this.jsonRpcBothFields = "both".equals(jsonRpcResultField);
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.setCharacterEncodings(servletRequest, servletResponse);
        servletResponse.setContentType("application/json");
        String method = servletRequest.getMethod();
        if (!"GET".equals(method) && !"POST".equals(method)) {
            this.sendError(servletResponse, new ResponseItem(400, "Only POST/GET Allowed"));
            return;
        }
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        HttpUtil.setCORSheader(servletResponse, this.containerConfig.getList(token.getContainer(), "gadgets.parentOrigins"));
        try {
            JSONObject request;
            String content = null;
            String callback = null;
            HashMap formData = Maps.newHashMap();
            if ("POST".equals(method)) {
                content = this.getPostContent(servletRequest, formData);
            } else if (HttpUtil.isJSONP(servletRequest)) {
                content = servletRequest.getParameter(REQUEST_PARAM);
                callback = servletRequest.getParameter("callback");
            } else {
                request = JsonConversionUtil.fromRequest(servletRequest);
                if (request != null) {
                    this.dispatch(request, formData, servletRequest, servletResponse, token, null);
                    return;
                }
            }
            if (content == null) {
                this.sendError(servletResponse, new ResponseItem(400, "No content specified"));
                return;
            }
            if (this.isContentJsonBatch(content)) {
                JSONArray batch = new JSONArray(content);
                this.dispatchBatch(batch, formData, servletRequest, servletResponse, token, callback);
            } else {
                request = new JSONObject(content);
                this.dispatch(request, formData, servletRequest, servletResponse, token, callback);
            }
        }
        catch (JSONException je) {
            this.sendJsonParseError(je, servletResponse);
        }
        catch (IllegalArgumentException e) {
            this.sendBadRequest(e, servletResponse);
        }
        catch (ContentTypes.InvalidContentTypeException icte) {
            this.sendBadRequest(icte, servletResponse);
        }
    }

    protected String getPostContent(HttpServletRequest request, Map<String, FormDataItem> formItems) throws ContentTypes.InvalidContentTypeException, IOException {
        String content = null;
        ContentTypes.checkContentTypes(ALLOWED_CONTENT_TYPES, request.getContentType());
        if (this.formParser.isMultipartContent(request)) {
            for (FormDataItem item : this.formParser.parse(request)) {
                if (item.isFormField() && REQUEST_PARAM.equals(item.getFieldName()) && content == null) {
                    if (!Strings.isNullOrEmpty((String)item.getContentType())) {
                        ContentTypes.checkContentTypes(ContentTypes.ALLOWED_JSON_CONTENT_TYPES, item.getContentType());
                    }
                    content = item.getAsString();
                    continue;
                }
                formItems.put(item.getFieldName(), item);
            }
        } else {
            content = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
        }
        return content;
    }

    protected void dispatchBatch(JSONArray batch, Map<String, FormDataItem> formItems, HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token, String callback) throws JSONException, IOException {
        ArrayList responses = Lists.newArrayListWithCapacity((int)batch.length());
        for (int i = 0; i < batch.length(); ++i) {
            JSONObject batchObj = batch.getJSONObject(i);
            responses.add(this.getHandler(batchObj, servletRequest).execute(formItems, token, this.jsonConverter));
        }
        ArrayList<Object> result = new ArrayList<Object>(batch.length());
        for (int i = 0; i < batch.length(); ++i) {
            JSONObject batchObj = batch.getJSONObject(i);
            String key = null;
            if (batchObj.has("id")) {
                key = batchObj.getString("id");
            }
            result.add(this.getJSONResponse(key, this.getResponseItem((Future)responses.get(i))));
        }
        PrintWriter writer = servletResponse.getWriter();
        if (callback != null) {
            ((Writer)writer).append(callback).append('(');
        }
        this.jsonConverter.append(writer, result);
        if (callback != null) {
            ((Writer)writer).append(");\n");
        }
    }

    protected void dispatch(JSONObject request, Map<String, FormDataItem> formItems, HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token, String callback) throws JSONException, IOException {
        String key = null;
        if (request.has("id")) {
            key = request.getString("id");
        }
        Future<?> future = this.getHandler(request, servletRequest).execute(formItems, token, this.jsonConverter);
        ResponseItem response = this.getResponseItem(future);
        Object result = this.getJSONResponse(key, response);
        PrintWriter writer = servletResponse.getWriter();
        if (callback != null) {
            ((Writer)writer).append(callback).append('(');
        }
        this.jsonConverter.append(writer, result);
        if (callback != null) {
            ((Writer)writer).append(");\n");
        }
    }

    protected void addResult(Map<String, Object> result, Object data) {
        if (this.jsonRpcBothFields) {
            result.put("result", data);
            result.put("data", data);
        } else {
            result.put(this.jsonRpcResultField, data);
        }
    }

    private boolean isContentJsonBatch(String content) {
        if (content == null) {
            return false;
        }
        return content.indexOf(91) != -1 && content.indexOf(91) < content.indexOf(123);
    }

    protected RpcHandler getHandler(JSONObject rpc, HttpServletRequest request) {
        return this.dispatcher.getRpcHandler(rpc);
    }

    protected Object getJSONResponse(String key, ResponseItem responseItem) {
        HashMap result = Maps.newHashMap();
        if (key != null) {
            result.put("id", key);
        }
        if (responseItem.getErrorCode() < 200 || responseItem.getErrorCode() >= 400) {
            result.put("error", this.getErrorJson(responseItem));
        } else {
            Object response = responseItem.getResponse();
            if (response instanceof DataCollection) {
                this.addResult(result, ((DataCollection)response).getEntry());
            } else if (response instanceof RestfulCollection) {
                HashMap map = Maps.newHashMap();
                RestfulCollection collection = (RestfulCollection)response;
                if (collection.getTotalResults() != collection.getList().size()) {
                    map.put("startIndex", collection.getStartIndex());
                    map.put("itemsPerPage", collection.getItemsPerPage());
                }
                map.put("totalResults", collection.getTotalResults());
                map.put("filtered", collection.isFiltered());
                map.put("updatedSince", collection.isUpdatedSince());
                map.put("sorted", collection.isSorted());
                map.put("list", collection.getList());
                this.addResult(result, map);
            } else {
                this.addResult(result, response);
            }
        }
        return result;
    }

    protected Object getErrorJson(ResponseItem responseItem) {
        HashMap<String, Object> error = new HashMap<String, Object>(2, 1.0f);
        error.put("code", responseItem.getErrorCode());
        String message = errorTitles.get(responseItem.getErrorCode());
        if (message == null) {
            message = responseItem.getErrorMessage();
        } else if (StringUtils.isNotBlank((CharSequence)responseItem.getErrorMessage())) {
            message = message + ": " + responseItem.getErrorMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            error.put("message", message);
        }
        if (responseItem.getResponse() != null) {
            error.put("data", responseItem.getResponse());
        }
        return error;
    }

    @Override
    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        this.jsonConverter.append(servletResponse.getWriter(), this.getErrorJson(responseItem));
        servletResponse.setStatus(responseItem.getErrorCode());
    }

    protected void sendBadRequest(Throwable t, HttpServletResponse response) throws IOException {
        this.sendError(response, new ResponseItem(400, "Invalid input - " + t.getMessage()));
    }

    protected void sendJsonParseError(JSONException e, HttpServletResponse response) throws IOException {
        this.sendError(response, new ResponseItem(400, "Invalid JSON - " + e.getMessage()));
    }
}

