/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BlobExpiredException;
import org.apache.shindig.common.util.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecurityToken
implements SecurityToken {
    private static final long CLOCK_SKEW_ALLOWANCE = 180L;
    public static final int DEFAULT_MAX_TOKEN_TTL = 3600;
    private static final TimeSource TIME_SOURCE = new TimeSource();
    private String ownerId;
    private String viewerId;
    private String appId;
    private String domain;
    private String container;
    private String appUrl;
    private long moduleId = 0L;
    private Long expiresAt;
    private String trustedJson;
    private String activeUrl;
    private TimeSource timeSource = TIME_SOURCE;
    private int tokenTTL;

    @VisibleForTesting
    protected AbstractSecurityToken setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    protected TimeSource getTimeSource() {
        return this.timeSource;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    protected AbstractSecurityToken setOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @Override
    public String getViewerId() {
        return this.viewerId;
    }

    protected AbstractSecurityToken setViewerId(String viewerId) {
        this.viewerId = viewerId;
        return this;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    protected AbstractSecurityToken setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    protected AbstractSecurityToken setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    protected AbstractSecurityToken setContainer(String container) {
        this.container = container;
        return this;
    }

    @Override
    public String getAppUrl() {
        return this.appUrl;
    }

    protected AbstractSecurityToken setAppUrl(String appUrl) {
        this.appUrl = appUrl;
        return this;
    }

    @Override
    public long getModuleId() {
        return this.moduleId;
    }

    protected AbstractSecurityToken setModuleId(long moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    @Override
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    protected AbstractSecurityToken setExpires() {
        return this.setExpires(3600);
    }

    protected AbstractSecurityToken setExpires(int tokenTTL) {
        this.tokenTTL = tokenTTL;
        return this.setExpiresAt(this.getTimeSource().currentTimeMillis() / 1000L + (long)this.getMaxTokenTTL());
    }

    protected AbstractSecurityToken setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Override
    public String getTrustedJson() {
        return this.trustedJson;
    }

    protected AbstractSecurityToken setTrustedJson(String trustedJson) {
        this.trustedJson = trustedJson;
        return this;
    }

    @Override
    public boolean isExpired() {
        try {
            this.enforceNotExpired();
        }
        catch (BlobExpiredException e) {
            return true;
        }
        return false;
    }

    public AbstractSecurityToken enforceNotExpired() throws BlobExpiredException {
        Long expiresAt = this.getExpiresAt();
        if (expiresAt != null) {
            long maxTime = expiresAt + 180L;
            long now = this.getTimeSource().currentTimeMillis() / 1000L;
            if (now >= maxTime) {
                throw new BlobExpiredException(now, maxTime);
            }
        }
        return this;
    }

    @Override
    public String getActiveUrl() {
        return this.activeUrl;
    }

    protected AbstractSecurityToken setActiveUrl(String activeUrl) {
        this.activeUrl = activeUrl;
        return this;
    }

    public Map<String, String> toMap() {
        HashMap map = Maps.newHashMap();
        for (Keys key : this.getMapKeys()) {
            String value = key.getValue(this);
            if (value == null) continue;
            map.put(key.getKey(), key.getValue(this));
        }
        return map;
    }

    protected int getMaxTokenTTL() {
        return this.tokenTTL;
    }

    protected AbstractSecurityToken loadFromMap(Map<String, String> map) {
        for (Keys key : this.getMapKeys()) {
            key.loadFromMap(this, map);
        }
        return this;
    }

    protected abstract EnumSet<Keys> getMapKeys();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        OWNER("o"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getOwnerId();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setOwnerId(map.get(this.key));
            }
        }
        ,
        VIEWER("v"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getViewerId();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setViewerId(map.get(this.key));
            }
        }
        ,
        APP_ID("i"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getAppId();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setAppId(map.get(this.key));
            }
        }
        ,
        DOMAIN("d"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getDomain();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setDomain(map.get(this.key));
            }
        }
        ,
        CONTAINER("c"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getContainer();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setContainer(map.get(this.key));
            }
        }
        ,
        APP_URL("u"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getAppUrl();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setAppUrl(map.get(this.key));
            }
        }
        ,
        MODULE_ID("m"){

            @Override
            public String getValue(SecurityToken token) {
                long value = token.getModuleId();
                if (value == 0L) {
                    return null;
                }
                return Long.toString(token.getModuleId(), 10);
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                String value = map.get(this.key);
                if (value != null) {
                    token.setModuleId(Long.parseLong(value, 10));
                }
            }
        }
        ,
        EXPIRES("x"){

            @Override
            public String getValue(SecurityToken token) {
                Long value = token.getExpiresAt();
                if (value == null) {
                    return null;
                }
                return Long.toString(token.getExpiresAt(), 10);
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                String value = map.get(this.key);
                if (value != null) {
                    token.setExpiresAt(Long.parseLong(value, 10));
                }
            }
        }
        ,
        TRUSTED_JSON("j"){

            @Override
            public String getValue(SecurityToken token) {
                return token.getTrustedJson();
            }

            @Override
            public void loadFromMap(AbstractSecurityToken token, Map<String, String> map) {
                token.setTrustedJson(map.get(this.key));
            }
        };

        protected String key;

        private Keys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public abstract String getValue(SecurityToken var1);

        public abstract void loadFromMap(AbstractSecurityToken var1, Map<String, String> var2);
    }
}

