/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.annotations.VisibleForTesting;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthInfoUtil {
    private AuthInfoUtil() {
    }

    public static SecurityToken getSecurityTokenFromRequest(HttpServletRequest req) {
        return (SecurityToken)AuthInfoUtil.getRequestAttribute(req, Attribute.SECURITY_TOKEN);
    }

    public static String getAuthTypeFromRequest(HttpServletRequest req) {
        return (String)AuthInfoUtil.getRequestAttribute(req, Attribute.AUTH_TYPE);
    }

    public static void setSecurityTokenForRequest(HttpServletRequest req, SecurityToken token) {
        AuthInfoUtil.setRequestAttribute(req, Attribute.SECURITY_TOKEN, token);
    }

    public static void setAuthTypeForRequest(HttpServletRequest req, String authType) {
        AuthInfoUtil.setRequestAttribute(req, Attribute.AUTH_TYPE, authType);
    }

    private static <T> void setRequestAttribute(HttpServletRequest req, Attribute att, T value) {
        req.setAttribute(att.getId(), value);
    }

    private static <T> T getRequestAttribute(HttpServletRequest req, Attribute att) {
        return (T)req.getAttribute(att.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    public static enum Attribute {
        SECURITY_TOKEN,
        AUTH_TYPE;


        public String getId() {
            return Attribute.class.getName() + '.' + this.name();
        }
    }
}

