/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthInfoUtil;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.InjectedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationServletFilter
extends InjectedFilter {
    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String CLASSNAME = AuthenticationServletFilter.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASSNAME, "org.apache.shindig.common.logging.i18n.resource");
    private String realm = "shindig";
    private List<AuthenticationHandler> handlers;

    @Inject(optional=true)
    public void setAuthenticationRealm(@Named(value="shindig.authentication.realm") String realm) {
        this.realm = realm;
    }

    @Inject
    public void setAuthenticationHandlers(List<AuthenticationHandler> handlers) {
        this.handlers = handlers;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Auth filter can only handle HTTP");
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String authHeader = null;
        try {
            for (AuthenticationHandler handler : this.handlers) {
                authHeader = handler.getWWWAuthenticateHeader(this.getRealm(req));
                SecurityToken token = handler.getSecurityTokenFromRequest(req);
                if (token != null) {
                    AuthInfoUtil.setAuthTypeForRequest(req, handler.getName());
                    AuthInfoUtil.setSecurityTokenForRequest(req, token);
                    this.callChain(chain, req, resp);
                    return;
                }
                this.setAuthHeader(authHeader, resp);
            }
            this.callChain(chain, req, resp);
        }
        catch (AuthenticationHandler.InvalidAuthenticationException iae) {
            Throwable cause = iae.getCause();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.logp(Level.INFO, CLASSNAME, "doFilter", "errorParsingSecureToken", cause);
            }
            if (iae.getAdditionalHeaders() != null) {
                for (Map.Entry<String, String> entry : iae.getAdditionalHeaders().entrySet()) {
                    resp.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (iae.getRedirect() != null) {
                this.onRedirect(req, resp, iae);
            }
            this.setAuthHeader(authHeader, resp);
            this.onError(req, resp, iae);
        }
    }

    protected String getRealm(HttpServletRequest request) {
        return this.realm;
    }

    protected void onError(HttpServletRequest req, HttpServletResponse resp, AuthenticationHandler.InvalidAuthenticationException iae) throws IOException {
        Throwable cause = iae.getCause();
        String message = cause == null ? iae.getMessage() : iae.getMessage() + cause.getMessage();
        resp.sendError(401, message);
    }

    protected void onRedirect(HttpServletRequest req, HttpServletResponse resp, AuthenticationHandler.InvalidAuthenticationException iae) throws IOException {
        resp.sendRedirect(iae.getRedirect());
    }

    private void setAuthHeader(@Nullable String authHeader, HttpServletResponse response) {
        if (authHeader != null) {
            response.addHeader(WWW_AUTHENTICATE_HEADER, authHeader);
        }
    }

    private void callChain(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getAttribute("STASHED_BODY") != null) {
            chain.doFilter((ServletRequest)new StashedBodyRequestwrapper(request), (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static class StashedBodyRequestwrapper
    extends HttpServletRequestWrapper {
        final InputStream rawStream;
        ServletInputStream stream;
        BufferedReader reader;

        StashedBodyRequestwrapper(HttpServletRequest wrapped) {
            super(wrapped);
            this.rawStream = new ByteArrayInputStream((byte[])wrapped.getAttribute("STASHED_BODY"));
        }

        public ServletInputStream getInputStream() throws IOException {
            Preconditions.checkState((this.reader == null ? 1 : 0) != 0, (Object)"The methods getInputStream() and getReader() are mutually exclusive.");
            if (this.stream == null) {
                this.stream = new ServletInputStream(){

                    public int read() throws IOException {
                        return StashedBodyRequestwrapper.this.rawStream.read();
                    }
                };
            }
            return this.stream;
        }

        public BufferedReader getReader() throws IOException {
            Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"The methods getInputStream() and getReader() are mutually exclusive.");
            if (this.reader == null) {
                Charset charset = Charset.forName(this.getCharacterEncoding());
                if (charset == null) {
                    charset = Charsets.UTF_8;
                }
                this.reader = new BufferedReader(new InputStreamReader(this.rawStream, charset));
            }
            return this.reader;
        }
    }
}

