/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.config.ContainerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BasicSecurityTokenCodec
implements SecurityTokenCodec,
ContainerConfig.ConfigObserver {
    private static final String CLASSNAME = BasicSecurityTokenCodec.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASSNAME);
    private static final int OWNER_INDEX = 0;
    private static final int VIEWER_INDEX = 1;
    private static final int APP_ID_INDEX = 2;
    private static final int DOMAIN_INDEX = 3;
    private static final int APP_URL_INDEX = 4;
    private static final int MODULE_ID_INDEX = 5;
    private static final int CONTAINER_ID_INDEX = 6;
    private static final int EXPIRY_INDEX = 7;
    private static final int TOKEN_COUNT = 7;
    private Map<String, Integer> tokenTTLs = Maps.newHashMap();

    @Override
    public String encodeToken(SecurityToken token) {
        Long expires = null;
        Integer tokenTTL = this.tokenTTLs.get(token.getContainer());
        if (token instanceof AbstractSecurityToken) {
            if (tokenTTL != null) {
                ((AbstractSecurityToken)token).setExpires(tokenTTL);
            } else {
                ((AbstractSecurityToken)token).setExpires();
            }
            expires = token.getExpiresAt();
        } else {
            BasicSecurityToken localToken = new BasicSecurityToken();
            if (tokenTTL != null) {
                localToken.setExpires(tokenTTL);
            } else {
                localToken.setExpires();
            }
            expires = localToken.getExpiresAt();
        }
        String encoded = Joiner.on((String)":").join((Object)Utf8UrlCoder.encode(token.getOwnerId()), (Object)Utf8UrlCoder.encode(token.getViewerId()), new Object[]{Utf8UrlCoder.encode(token.getAppId()), Utf8UrlCoder.encode(token.getDomain()), Utf8UrlCoder.encode(token.getAppUrl()), Long.toString(token.getModuleId(), 10), Utf8UrlCoder.encode(token.getContainer())});
        if (expires != null) {
            encoded = Joiner.on((char)':').join((Object)encoded, (Object)Long.toString(expires, 10), new Object[0]);
        }
        return encoded;
    }

    @Override
    public SecurityToken createToken(Map<String, String> parameters) throws SecurityTokenException {
        String token = parameters.get("token");
        if (token == null || token.trim().length() == 0) {
            return new AnonymousSecurityToken();
        }
        try {
            String[] tokens = StringUtils.split((String)token, (char)':');
            if (tokens.length < 7) {
                throw new SecurityTokenException("Malformed security token");
            }
            Long expires = null;
            if (tokens.length > 7 && !tokens[7].equals("")) {
                expires = Long.parseLong(Utf8UrlCoder.decode(tokens[7]), 10);
            }
            BasicSecurityToken basicToken = new BasicSecurityToken(Utf8UrlCoder.decode(tokens[0]), Utf8UrlCoder.decode(tokens[1]), Utf8UrlCoder.decode(tokens[2]), Utf8UrlCoder.decode(tokens[3]), Utf8UrlCoder.decode(tokens[4]), Utf8UrlCoder.decode(tokens[5]), Utf8UrlCoder.decode(tokens[6]), parameters.get("activeUrl"), expires);
            return basicToken.enforceNotExpired();
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SecurityTokenException(e);
        }
    }

    @Override
    public int getTokenTimeToLive() {
        return 3600;
    }

    @Override
    public int getTokenTimeToLive(String container) {
        Integer tokenTTL = this.tokenTTLs.get(container);
        if (tokenTTL == null) {
            return this.getTokenTimeToLive();
        }
        return tokenTTL;
    }

    public BasicSecurityTokenCodec() {
    }

    public BasicSecurityTokenCodec(ContainerConfig config) {
        config.addConfigObserver(this, true);
    }

    @Override
    public void containersChanged(ContainerConfig config, Collection<String> changed, Collection<String> removed) {
        for (String container : removed) {
            this.tokenTTLs.remove(container);
        }
        for (String container : changed) {
            int tokenTTL = config.getInt(container, "gadgets.securityTokenTTL");
            if (tokenTTL > 0) {
                this.tokenTTLs.put(container, tokenTTL);
                continue;
            }
            LOG.logp(Level.WARNING, CLASSNAME, "containersChanged", "Token TTL for container \"{0}\" was {1} and will be ignored.", new Object[]{container, tokenTTL});
        }
    }
}

