/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import java.util.EnumSet;
import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobCrypterSecurityToken
extends AbstractSecurityToken {
    private static final EnumSet<AbstractSecurityToken.Keys> MAP_KEYS = EnumSet.of(AbstractSecurityToken.Keys.OWNER, new AbstractSecurityToken.Keys[]{AbstractSecurityToken.Keys.VIEWER, AbstractSecurityToken.Keys.APP_URL, AbstractSecurityToken.Keys.MODULE_ID, AbstractSecurityToken.Keys.EXPIRES, AbstractSecurityToken.Keys.TRUSTED_JSON});

    public BlobCrypterSecurityToken(String container, String domain, String activeUrl, Map<String, String> values) {
        if (values != null) {
            this.loadFromMap(values);
        }
        this.setContainer(container).setDomain(domain).setActiveUrl(activeUrl);
    }

    @Override
    public String getUpdatedToken() {
        return null;
    }

    @Override
    public String getAuthenticationMode() {
        return AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public String getAppId() {
        return this.getAppUrl();
    }

    @Override
    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return MAP_KEYS;
    }

    public static BlobCrypterSecurityToken fromToken(SecurityToken token) {
        BlobCrypterSecurityToken interpretedToken = new BlobCrypterSecurityToken(token.getContainer(), token.getDomain(), token.getActiveUrl(), null);
        interpretedToken.setAppId(token.getAppId()).setAppUrl(token.getAppUrl()).setExpiresAt(token.getExpiresAt()).setModuleId(token.getModuleId()).setOwnerId(token.getOwnerId()).setTrustedJson(token.getTrustedJson()).setViewerId(token.getViewerId());
        return interpretedToken;
    }
}

