/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.config.ContainerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BlobCrypterSecurityTokenCodec
implements SecurityTokenCodec,
ContainerConfig.ConfigObserver {
    private static final String CLASSNAME = BlobCrypterSecurityTokenCodec.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASSNAME);
    public static final String SECURITY_TOKEN_KEY = "gadgets.securityTokenKey";
    public static final String SIGNED_FETCH_DOMAIN = "gadgets.signedFetchDomain";
    protected Map<String, BlobCrypter> crypters = Maps.newHashMap();
    protected Map<String, String> domains = Maps.newHashMap();
    private Map<String, Integer> tokenTTLs = Maps.newHashMap();

    @Inject
    public BlobCrypterSecurityTokenCodec(ContainerConfig config) {
        try {
            config.addConfigObserver(this, false);
            this.loadContainers(config, config.getContainers(), this.crypters, this.domains, this.tokenTTLs);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error while initializing BlobCrypterSecurityTokenCodec", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void containersChanged(ContainerConfig config, Collection<String> changed, Collection<String> removed) {
        HashMap newCrypters = Maps.newHashMap(this.crypters);
        HashMap newDomains = Maps.newHashMap(this.domains);
        HashMap newTokenTTLs = Maps.newHashMap(this.tokenTTLs);
        try {
            this.loadContainers(config, changed, newCrypters, newDomains, newTokenTTLs);
            for (String container : removed) {
                newCrypters.remove(container);
                newDomains.remove(container);
                newTokenTTLs.remove(container);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "There was an error loading an updated container configuration. Keeping old configuration.", e);
            return;
        }
        this.crypters = newCrypters;
        this.domains = newDomains;
        this.tokenTTLs = newTokenTTLs;
    }

    private void loadContainers(ContainerConfig config, Collection<String> containers, Map<String, BlobCrypter> crypters, Map<String, String> domains, Map<String, Integer> tokenTTLs) throws IOException {
        for (String container : containers) {
            String key = config.getString(container, SECURITY_TOKEN_KEY);
            if (key != null) {
                BlobCrypter crypter = this.loadCrypter(key);
                crypters.put(container, crypter);
            }
            String domain = config.getString(container, SIGNED_FETCH_DOMAIN);
            domains.put(container, domain);
            int tokenTTL = config.getInt(container, "gadgets.securityTokenTTL");
            if (tokenTTL > 0) {
                tokenTTLs.put(container, tokenTTL);
                continue;
            }
            LOG.logp(Level.WARNING, CLASSNAME, "loadContainers", "Token TTL for container \"{0}\" was {1} and will be ignored.", new Object[]{container, tokenTTL});
        }
    }

    protected BlobCrypter loadCrypter(String key) {
        return new BasicBlobCrypter(key);
    }

    @Override
    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        String token = tokenParameters.get("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            return new AnonymousSecurityToken();
        }
        String[] fields = StringUtils.split((String)token, (char)':');
        if (fields.length != 2) {
            throw new SecurityTokenException("Invalid security token " + token);
        }
        String container = fields[0];
        BlobCrypter crypter = this.crypters.get(container);
        if (crypter == null) {
            throw new SecurityTokenException("Unknown container " + token);
        }
        String domain = this.domains.get(container);
        String activeUrl = tokenParameters.get("activeUrl");
        String crypted = fields[1];
        try {
            BlobCrypterSecurityToken st = new BlobCrypterSecurityToken(container, domain, activeUrl, crypter.unwrap(crypted));
            return st.enforceNotExpired();
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
    }

    @Override
    public String encodeToken(SecurityToken token) throws SecurityTokenException {
        if (!token.getAuthenticationMode().equals(AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name())) {
            throw new SecurityTokenException("Can only encode BlobCrypterSecurityTokens");
        }
        AbstractSecurityToken aToken = token instanceof AbstractSecurityToken ? (AbstractSecurityToken)token : BlobCrypterSecurityToken.fromToken(token);
        BlobCrypter crypter = this.crypters.get(aToken.getContainer());
        if (crypter == null) {
            throw new SecurityTokenException("Unknown container " + aToken.getContainer());
        }
        try {
            Integer tokenTTL = this.tokenTTLs.get(aToken.getContainer());
            if (tokenTTL != null) {
                aToken.setExpires(tokenTTL);
            } else {
                aToken.setExpires();
            }
            return aToken.getContainer() + ':' + crypter.wrap(aToken.toMap());
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
    }

    @Override
    public int getTokenTimeToLive() {
        return 3600;
    }

    @Override
    public int getTokenTimeToLive(String container) {
        Integer tokenTTL = this.tokenTTLs.get(container);
        if (tokenTTL == null) {
            return this.getTokenTimeToLive();
        }
        return tokenTTL;
    }
}

